/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.opennms.core.criteria.Criteria;
import org.opennms.features.topology.api.browsers.OnmsContainerDatasource;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class OnmsDaoContainerDatasource<T, K extends Serializable>
implements OnmsContainerDatasource<T, K> {
    private final OnmsDao<T, K> dao;
    private final TransactionOperations transactionTemplate;

    public OnmsDaoContainerDatasource(OnmsDao<T, K> dao, TransactionOperations transactionTemplate) {
        this.dao = Objects.requireNonNull(dao);
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate);
    }

    public void clear() {
        this.dao.clear();
    }

    public void delete(K itemId) {
        this.dao.delete(itemId);
    }

    public List<T> findMatching(final Criteria criteria) {
        return (List)this.transactionTemplate.execute(new TransactionCallback<List<T>>(){

            public List<T> doInTransaction(TransactionStatus arg0) {
                List matchingItems = OnmsDaoContainerDatasource.this.dao.findMatching(criteria);
                matchingItems.forEach(t -> OnmsDaoContainerDatasource.this.findMatchingCallback(t));
                return matchingItems;
            }
        });
    }

    public void findMatchingCallback(T item) {
    }

    public int countMatching(Criteria criteria) {
        return this.dao.countMatching(criteria);
    }

    public T createInstance(Class<T> itemClass) throws IllegalAccessException, InstantiationException {
        return itemClass.newInstance();
    }
}

