/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.outages.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.codehaus.jackson.map.ObjectMapper;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JacksonUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.common.api.SaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.FileSystemSaveableConfigContainer;
import org.opennms.netmgt.config.dao.outages.api.WriteablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.impl.AbstractPollOutagesDao;
import org.opennms.netmgt.config.poller.outages.Outages;

public class OnmsPollOutagesDao
extends AbstractPollOutagesDao
implements WriteablePollOutagesDao {
    private final SaveableConfigContainer<Outages> saveableConfigContainer;
    private final ObjectMapper objectMapper = JacksonUtils.createDefaultObjectMapper();
    private volatile Outages filesystemConfig;

    @VisibleForTesting
    OnmsPollOutagesDao(JsonStore jsonStore, File configFile) {
        super(jsonStore);
        Objects.requireNonNull(configFile);
        this.saveableConfigContainer = new FileSystemSaveableConfigContainer(Outages.class, "poll-outages", Collections.singleton(this::fileSystemConfigUpdated), configFile);
        this.reload();
    }

    public OnmsPollOutagesDao(JsonStore jsonStore) throws IOException {
        this(jsonStore, ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME));
    }

    public Lock getReadLock() {
        return this.saveableConfigContainer.getReadLock();
    }

    public Lock getWriteLock() {
        return this.saveableConfigContainer.getWriteLock();
    }

    public void withWriteLock(Consumer<Outages> consumerWithLock) {
        this.getWriteLock().lock();
        try {
            consumerWithLock.accept(this.getWriteableConfig());
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public void saveConfig() {
        this.saveableConfigContainer.saveConfig();
    }

    public Outages getReadOnlyConfig() {
        return (Outages)this.saveableConfigContainer.getConfig();
    }

    public Outages getWriteableConfig() {
        return this.getReadOnlyConfig();
    }

    public void reload() {
        this.saveableConfigContainer.reload();
    }

    public void onConfigChanged() {
        try {
            this.jsonStore.put("poll-outages", (Object)this.objectMapper.writeValueAsString((Object)this.filesystemConfig), "config");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void fileSystemConfigUpdated(Outages updatedConfig) {
        this.filesystemConfig = updatedConfig;
        this.onConfigChanged();
    }
}

