/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.bsf;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.Destination;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="engine")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BSFEngineHandler
implements Destination {
    private static final long serialVersionUID = 6351398964945801319L;
    private static final Logger LOG = LoggerFactory.getLogger(BSFEngineHandler.class);
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="filter", required=false)
    private String m_filter;
    @XmlElement(name="language", required=false, defaultValue="beanshell")
    private String m_language;
    @XmlElement(name="className", required=false, defaultValue="bsh.util.BeanShellBSFEngine")
    private String m_className;
    @XmlElement(name="extensions", required=false, defaultValue="bsh")
    private String m_extensions;
    @XmlElement(name="onStart", required=false)
    private String m_onStart;
    @XmlElement(name="onStop", required=false)
    private String m_onStop;
    @XmlElement(name="onAlarm", required=true)
    private String m_onAlarm;

    public boolean isFirstOccurrenceOnly() {
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    public String getLanguage() {
        return this.m_language == null ? "beanshell" : this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public String getClassName() {
        return this.m_className == null ? "bsh.util.BeanShellBSFEngine" : this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public String getExtensions() {
        return this.m_extensions == null ? "bsh" : this.m_extensions;
    }

    public void setExtensions(String extensions) {
        this.m_extensions = extensions;
    }

    public String getOnStart() {
        return this.m_onStart;
    }

    public void setOnStart(String onStart) {
        this.m_onStart = onStart;
    }

    public String getOnStop() {
        return this.m_onStop;
    }

    public void setOnStop(String onStop) {
        this.m_onStop = onStop;
    }

    public String getOnAlarm() {
        return this.m_onAlarm;
    }

    public void setOnAlarm(String onAlarm) {
        this.m_onAlarm = onAlarm;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (this.getFilter() != null) {
            StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(this.m_filter);
            boolean passed = false;
            try {
                passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
            }
            catch (Exception e) {
                LOG.warn("accepts: can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getFilter(), alarm.getUei(), e.getMessage()});
            }
            LOG.debug("accepts: checking {} ? {}", (Object)this.m_filter, (Object)passed);
            return passed;
        }
        return true;
    }
}

