/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opennms.features.config.exception.ValidationException;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.EventType;
import org.opennms.features.config.service.util.PropertiesConversionUtil;

public class CmProperties {
    private Map<String, Object> properties;
    private final ConfigurationManagerService cm;
    private final ConfigUpdateInfo configIdentifier;
    private final Lock lock = new ReentrantLock();
    private boolean needReload = false;

    public CmProperties(ConfigurationManagerService cm, ConfigUpdateInfo configIdentifier) {
        this.cm = Objects.requireNonNull(cm);
        this.configIdentifier = Objects.requireNonNull(configIdentifier);
        cm.registerEventHandler(EventType.UPDATE, configIdentifier, key -> {
            this.needReload = true;
        });
    }

    private Optional<Map<String, Object>> read() {
        Optional<Map<String, Object>> result = this.cm.getJSONStrConfiguration(this.configIdentifier.getConfigName(), this.configIdentifier.getConfigId()).map(PropertiesConversionUtil::jsonToMap);
        this.needReload = false;
        return result;
    }

    private void write() throws ValidationException {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            entries.put(entry.getKey().toString(), entry.getValue());
        }
        this.cm.updateConfiguration(this.configIdentifier.getConfigName(), this.configIdentifier.getConfigId(), PropertiesConversionUtil.mapToJsonString(entries), false);
    }

    public Map<String, Object> get() {
        this.lock.lock();
        try {
            if (this.properties == null || this.needReload) {
                this.properties = this.read().orElse(new ConcurrentHashMap());
            }
            Map<String, Object> map = this.properties;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setProperty(String key, Object value) throws ValidationException {
        this.lock.lock();
        try {
            if (!value.equals(this.get().get(key))) {
                this.get().put(key, value);
                this.write();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Object getProperty(String key) {
        this.lock.lock();
        try {
            Object object = this.get().get(key);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }
}

