/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import com.google.common.base.Strings;
import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import com.googlecode.concurentlocks.ReentrantReadWriteUpdateLock;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.ISO8601DateEditor;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBuilderSearchVisitor;
import org.opennms.web.rest.support.DateCollection;
import org.opennms.web.rest.support.FloatCollection;
import org.opennms.web.rest.support.IntegerCollection;
import org.opennms.web.rest.support.LongCollection;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.support.SearchPropertyCollection;
import org.opennms.web.rest.support.StringCollection;
import org.opennms.web.utils.CriteriaBuilderUtils;
import org.opennms.web.utils.QueryParameters;
import org.opennms.web.utils.QueryParametersBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractDaoRestServiceWithDTO<T, D, Q, K extends Serializable, I extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDaoRestServiceWithDTO.class);
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;
    @Autowired
    private SessionFactory m_sessionFactory;
    private final ReadWriteUpdateLock m_globalLock = new ReentrantReadWriteUpdateLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected static final int DEFAULT_LIMIT = 10;

    protected abstract OnmsDao<T, K> getDao();

    protected abstract Class<T> getDaoClass();

    protected abstract Class<Q> getQueryBeanClass();

    protected abstract CriteriaBuilder getCriteriaBuilder(UriInfo var1);

    protected abstract JaxbListWrapper<D> createListWrapper(Collection<D> var1);

    protected abstract T doGet(UriInfo var1, I var2);

    protected final void writeLock() {
        this.m_writeLock.lock();
    }

    protected final void writeUnlock() {
        this.m_writeLock.unlock();
    }

    protected Response doCreate(SecurityContext securityContext, UriInfo uriInfo, T object) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, K key, T targetObject) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    protected Response doUpdateProperties(SecurityContext securityContext, UriInfo uriInfo, T targetObject, MultivaluedMapImpl params) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, T object) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build());
    }

    protected Set<SearchProperty> getQueryProperties() {
        return Collections.emptySortedSet();
    }

    protected Map<String, String> getSearchBeanPropertyMap() {
        return null;
    }

    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        return null;
    }

    protected Criteria getCriteria(UriInfo uriInfo, SearchContext searchContext) {
        CriteriaBuilder builder = this.getCriteriaBuilder(uriInfo);
        if (searchContext != null && !Strings.isNullOrEmpty((String)searchContext.getSearchExpression())) {
            try {
                SearchCondition condition = searchContext.getCondition(this.getQueryBeanClass(), this.getSearchBeanPropertyMap());
                if (condition != null) {
                    CriteriaBuilderSearchVisitor visitor = new CriteriaBuilderSearchVisitor(builder, this.getDaoClass(), this.getCriteriaBehaviors());
                    condition.accept(visitor);
                }
            }
            catch (ArrayIndexOutOfBoundsException | SearchParseException e) {
                LOG.warn(e.getClass().getSimpleName() + " while parsing FIQL search, ignoring: " + e.getMessage(), e);
                throw new IllegalArgumentException("Error parsing FIQL search");
            }
        }
        MultivaluedMap params = uriInfo.getQueryParameters();
        AbstractDaoRestServiceWithDTO.applyLimitOffsetOrderBy((MultivaluedMap<String, String>)params, builder);
        Criteria crit = builder.toCriteria();
        return crit;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response get(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        Criteria crit = this.getCriteria(uriInfo, searchContext);
        List coll = this.getDao().findMatching(crit);
        if (coll == null || coll.size() < 1) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        Integer offset = crit.getOffset();
        crit.setLimit(null);
        crit.setOffset(null);
        crit.setOrders(new ArrayList());
        int totalCount = this.getDao().countMatching(crit);
        List collOfDtos = coll.stream().map(this::mapEntityToDTO).collect(Collectors.toList());
        JaxbListWrapper list = this.createListWrapper(collOfDtos);
        list.setTotalCount(Integer.valueOf(totalCount));
        list.setOffset(offset);
        offset = offset == null ? 0 : offset;
        return Response.ok(list).header("Content-Range", (Object)String.format("items %d-%d/%d", offset, offset + coll.size() - 1, totalCount)).build();
    }

    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public Response getCount(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        return Response.ok((Object)String.valueOf(this.getDao().countMatching(this.getCriteria(uriInfo, searchContext)))).build();
    }

    @GET
    @Path(value="properties")
    @Produces(value={"application/json", "application/xml"})
    public Response getProperties(@QueryParam(value="q") String query) {
        Set<SearchProperty> props = this.getQueryProperties();
        if (props != null && props.size() > 0) {
            return Response.ok((Object)((Object)new SearchPropertyCollection(props.stream().filter(s -> {
                if (query != null && query.length() > 0) {
                    return s.name.toLowerCase().indexOf(query.toLowerCase()) >= 0;
                }
                return true;
            }).collect(Collectors.toList())))).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="properties/{propertyId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getPropertyValues(@PathParam(value="propertyId") String propertyId, @QueryParam(value="q") String query, @QueryParam(value="limit") Integer limit) {
        Set<SearchProperty> props = this.getQueryProperties();
        Optional<SearchProperty> prop = props.stream().filter(p -> p.getId().equals(propertyId)).findAny();
        if (prop.isPresent()) {
            SearchProperty property = prop.get();
            if (property.values != null && property.values.size() > 0) {
                Set<String> validValues = query != null && query.length() > 0 ? property.values.keySet().stream().filter(v -> v.contains(query)).collect(Collectors.toSet()) : property.values.keySet();
                switch (property.type) {
                    case FLOAT: {
                        return Response.ok((Object)((Object)new FloatCollection(validValues.stream().map(Float::parseFloat).collect(Collectors.toList())))).build();
                    }
                    case INTEGER: {
                        return Response.ok((Object)((Object)new IntegerCollection(validValues.stream().map(Integer::parseInt).collect(Collectors.toList())))).build();
                    }
                    case LONG: {
                        return Response.ok((Object)((Object)new LongCollection(validValues.stream().map(Long::parseLong).collect(Collectors.toList())))).build();
                    }
                    case IP_ADDRESS: 
                    case STRING: {
                        return Response.ok((Object)((Object)new StringCollection(validValues))).build();
                    }
                    case TIMESTAMP: {
                        return Response.ok((Object)((Object)new DateCollection(validValues.stream().map(v -> {
                            try {
                                return ISO8601DateEditor.stringToDate((String)v);
                            }
                            catch (IllegalArgumentException | UnsupportedOperationException e) {
                                LOG.error("Invalid date in value list: " + v, (Throwable)e);
                                return null;
                            }
                        }).filter(Objects::nonNull).collect(Collectors.toList())))).build();
                    }
                }
                return Response.noContent().build();
            }
            switch (property.type) {
                case FLOAT: {
                    List floats = (List)new HibernateTemplate(this.m_sessionFactory).execute(new HibernateListCallback(property, query, limit));
                    return Response.ok((Object)((Object)new FloatCollection(floats))).build();
                }
                case INTEGER: {
                    List ints = (List)new HibernateTemplate(this.m_sessionFactory).execute(new HibernateListCallback(property, query, limit));
                    return Response.ok((Object)((Object)new IntegerCollection(ints))).build();
                }
                case LONG: {
                    List longs = (List)new HibernateTemplate(this.m_sessionFactory).execute(new HibernateListCallback(property, query, limit));
                    return Response.ok((Object)((Object)new LongCollection(longs))).build();
                }
                case IP_ADDRESS: {
                    List addresses = (List)new HibernateTemplate(this.m_sessionFactory).execute(new HibernateListCallback(property, query, limit));
                    return Response.ok((Object)((Object)new StringCollection(addresses.stream().map(InetAddressUtils::str).collect(Collectors.toList())))).build();
                }
                case STRING: {
                    List strings = (List)new HibernateTemplate(this.m_sessionFactory).execute(new HibernateListCallback(property, query, limit));
                    return Response.ok((Object)((Object)new StringCollection(strings))).build();
                }
                case TIMESTAMP: {
                    List dates = (List)new HibernateTemplate(this.m_sessionFactory).execute(new HibernateListCallback(property, query, limit));
                    return Response.ok((Object)((Object)new DateCollection(dates))).build();
                }
            }
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response get(@Context UriInfo uriInfo, @PathParam(value="id") I id) {
        T retval = this.doGet(uriInfo, id);
        if (retval == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.mapEntityToDTO(retval)).build();
    }

    @POST
    @Path(value="{id}")
    public Response createSpecific() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response create(@Context SecurityContext securityContext, @Context UriInfo uriInfo, D object) {
        this.writeLock();
        try {
            Response response = this.doCreate(securityContext, uriInfo, this.mapDTOToEntity(object));
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateMany(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @Context SearchContext searchContext, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Criteria crit = this.getCriteria(uriInfo, searchContext);
            List objects = this.getDao().findMatching(crit);
            if (objects == null || objects.size() == 0) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            for (Object object : objects) {
                RestUtils.setBeanProperties(object, (MultivaluedMap)params);
                this.doUpdateProperties(securityContext, uriInfo, object, params);
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="{id}")
    public Response update(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @PathParam(value="id") K id, T object) {
        this.writeLock();
        try {
            if (object == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            Response response = this.doUpdate(securityContext, uriInfo, id, object);
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{id}")
    public Response updateProperties(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @PathParam(value="id") I id, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            T object = this.doGet(uriInfo, id);
            if (object == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            Response response = this.doUpdateProperties(securityContext, uriInfo, object, params);
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public Response deleteMany(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @Context SearchContext searchContext) {
        this.writeLock();
        try {
            Criteria crit = this.getCriteria(uriInfo, searchContext);
            List objects = this.getDao().findMatching(crit);
            if (objects == null || objects.size() == 0) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            for (Object object : objects) {
                this.doDelete(securityContext, uriInfo, object);
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{id}")
    public Response delete(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @PathParam(value="id") I id) {
        this.writeLock();
        try {
            T object = this.doGet(uriInfo, id);
            if (object == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            this.doDelete(securityContext, uriInfo, object);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    public static void applyLimitOffsetOrderBy(MultivaluedMap<String, String> p, CriteriaBuilder builder) {
        AbstractDaoRestServiceWithDTO.applyLimitOffsetOrderBy(p, builder, 10);
    }

    private static void applyLimitOffsetOrderBy(MultivaluedMap<String, String> p, CriteriaBuilder builder, Integer defaultLimit) {
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom(p);
        if (queryParameters.getLimit() == null) {
            queryParameters.setLimit(defaultLimit);
        }
        CriteriaBuilderUtils.applyQueryParameters((CriteriaBuilder)builder, (QueryParameters)queryParameters);
    }

    protected void sendEvent(Event event) {
        try {
            this.m_eventProxy.send(event);
        }
        catch (EventProxyException e) {
            throw AbstractDaoRestServiceWithDTO.getException(Response.Status.INTERNAL_SERVER_ERROR, "Cannot send event {} : {}", event.getUei(), e.getMessage());
        }
    }

    protected static WebApplicationException getException(Response.Status status, String msg, String ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    protected static void checkUserDefinedMetadataContext(String context) {
        if (!context.startsWith("X-")) {
            throw AbstractDaoRestServiceWithDTO.getException(Response.Status.FORBIDDEN, "Only metadata in contexts starting with 'X-' can be modified", new String[0]);
        }
    }

    public abstract D mapEntityToDTO(T var1);

    public abstract T mapDTOToEntity(D var1);

    private static class HibernateListCallback<T>
    implements HibernateCallback<List<T>> {
        private final SearchProperty property;
        private final String query;
        private final Integer limit;

        public HibernateListCallback(SearchProperty property, String query, Integer limit) {
            this.property = property;
            this.query = query;
            this.limit = limit;
        }

        public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
            Query hql;
            if (this.query != null && this.query.length() > 0) {
                hql = session.createQuery(String.format("select distinct %s from %s where lower(%s) like :query order by %s", this.property.id, this.property.entityClass.getSimpleName(), this.property.id, this.property.id));
                hql.setParameter("query", (Object)("%" + this.query.toLowerCase() + "%"));
            } else {
                hql = session.createQuery(String.format("select distinct %s from %s order by %s", this.property.id, this.property.entityClass.getSimpleName(), this.property.id));
            }
            if (this.limit != null && this.limit > 0) {
                hql.setMaxResults(this.limit.intValue());
            }
            List list = hql.list();
            return list;
        }
    }
}

