/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.imageio.ImageIO;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsOutageCollection;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="timelineRestService")
@Path(value="timeline")
@Tag(name="Timeline", description="Timeline API")
public class TimelineRestService
extends OnmsRestService {
    public static final ArrayList<TimescaleDescriptor> TIMESCALE_DESCRIPTORS;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private NodeDao m_nodeDao;

    private OnmsOutageCollection queryOutages(UriInfo uriInfo, int nodeId, String ipAddress, int serviceId, long start, long end) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsOutage.class);
        builder.eq("node.id", (Object)nodeId);
        Date startDate = new Date();
        startDate.setTime(start * 1000L);
        Date endDate = new Date();
        endDate.setTime(end * 1000L);
        builder.or(new Restriction[]{Restrictions.isNull((String)"ifRegainedService"), Restrictions.gt((String)"ifRegainedService", (Object)startDate)});
        builder.le("ifLostService", (Object)endDate);
        builder.eq("serviceType.id", (Object)serviceId);
        builder.eq("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddress));
        builder.isNull("perspective");
        builder.alias("monitoredService", "monitoredService");
        builder.alias("monitoredService.ipInterface", "ipInterface");
        builder.alias("monitoredService.ipInterface.node", "node");
        builder.alias("monitoredService.serviceType", "serviceType");
        TimelineRestService.applyQueryFilters((MultivaluedMap<String, String>)uriInfo.getQueryParameters(), builder, null);
        builder.orderBy("id").desc();
        OnmsOutageCollection onmsOutageCollection = new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(builder.toCriteria()));
        return onmsOutageCollection;
    }

    @GET
    @Produces(value={"image/png"})
    @Transactional
    @Path(value="header/{start}/{end}/{width}")
    public Response header(@PathParam(value="start") long start, @PathParam(value="end") long end, @PathParam(value="width") int width) throws IOException {
        long delta = end - start;
        BufferedImage bufferedImage = new BufferedImage(width, 20, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(new Font("SansSerif", 0, 10));
        graphics2D.setColor(Color.BLACK);
        int numLabels = TimescaleDescriptor.computeNumberOfLabels(graphics2D, delta, width);
        for (TimescaleDescriptor desc : TIMESCALE_DESCRIPTORS) {
            if (!desc.match(delta, numLabels)) continue;
            desc.drawHeader(graphics2D, delta, start, width);
            break;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        byte[] imageData = baos.toByteArray();
        return Response.ok((Object)imageData).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Transactional
    @Path(value="html/{nodeId}/{ipAddress}/{serviceId}/{start}/{end}/{width}")
    public Response html(@Context UriInfo uriInfo, @PathParam(value="nodeId") int nodeId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="serviceId") int serviceId, @PathParam(value="start") long start, @PathParam(value="end") long end, @PathParam(value="width") int width) throws IOException {
        long delta = end - start;
        OnmsOutageCollection onmsOutageCollection = this.queryOutages(uriInfo, nodeId, ipAddress, serviceId, start, end);
        BufferedImage bufferedImage = new BufferedImage(width, 20, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(new Font("SansSerif", 0, 10));
        graphics2D.setColor(Color.BLACK);
        int numLabels = TimescaleDescriptor.computeNumberOfLabels(graphics2D, delta, width);
        String encodedIpAddress = URLEncoder.encode(ipAddress, "UTF-8");
        StringBuffer htmlBuffer = new StringBuffer();
        htmlBuffer.append("<img src=\"/opennms/rest/timeline/image/");
        htmlBuffer.append(nodeId);
        htmlBuffer.append("/");
        htmlBuffer.append(encodedIpAddress);
        htmlBuffer.append("/");
        htmlBuffer.append(serviceId);
        htmlBuffer.append("/");
        htmlBuffer.append(start);
        htmlBuffer.append("/");
        htmlBuffer.append(end);
        htmlBuffer.append("/");
        htmlBuffer.append(width);
        htmlBuffer.append("\" usemap=\"#");
        htmlBuffer.append(nodeId);
        htmlBuffer.append("-");
        htmlBuffer.append(encodedIpAddress);
        htmlBuffer.append("-");
        htmlBuffer.append(serviceId);
        htmlBuffer.append("\"><map name=\"");
        htmlBuffer.append(nodeId);
        htmlBuffer.append("-");
        htmlBuffer.append(encodedIpAddress);
        htmlBuffer.append("-");
        htmlBuffer.append(serviceId);
        htmlBuffer.append("\">");
        for (TimescaleDescriptor desc : TIMESCALE_DESCRIPTORS) {
            if (!desc.match(delta, numLabels)) continue;
            for (OnmsOutage onmsOutage : onmsOutageCollection) {
                htmlBuffer.append(desc.getMapEntry(graphics2D, delta, start, width, onmsOutage));
            }
        }
        htmlBuffer.append("</map>");
        return Response.ok((Object)htmlBuffer.toString()).build();
    }

    @GET
    @Produces(value={"image/png"})
    @Transactional
    @Path(value="image/{nodeId}/{ipAddress}/{serviceId}/{start}/{end}/{width}")
    public Response image(@Context UriInfo uriInfo, @PathParam(value="nodeId") int nodeId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="serviceId") int serviceId, @PathParam(value="start") long start, @PathParam(value="end") long end, @PathParam(value="width") int width) throws IOException {
        long delta = end - start;
        OnmsOutageCollection onmsOutageCollection = this.queryOutages(uriInfo, nodeId, ipAddress, serviceId, start, end);
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        BufferedImage bufferedImage = new BufferedImage(width, 20, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(new Font("SansSerif", 0, 10));
        graphics2D.setColor(Color.BLACK);
        int numLabels = TimescaleDescriptor.computeNumberOfLabels(graphics2D, delta, width);
        for (TimescaleDescriptor desc : TIMESCALE_DESCRIPTORS) {
            if (!desc.match(delta, numLabels)) continue;
            desc.drawNode(graphics2D, delta, start, width, node);
            for (OnmsOutage onmsOutage : onmsOutageCollection) {
                desc.drawOutage(graphics2D, delta, start, width, onmsOutage);
            }
            desc.drawLine(graphics2D, delta, start, width);
            break;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        byte[] imageData = baos.toByteArray();
        return Response.ok((Object)imageData).build();
    }

    @GET
    @Produces(value={"image/png"})
    @Transactional
    @Path(value="empty/{start}/{end}/{width}")
    public Response empty(@PathParam(value="start") long start, @PathParam(value="end") long end, @PathParam(value="width") int width) throws IOException {
        int delta = (int)end - (int)start;
        BufferedImage bufferedImage = new BufferedImage(width, 20, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(new Font("SansSerif", 0, 10));
        graphics2D.setColor(Color.BLACK);
        int numLabels = TimescaleDescriptor.computeNumberOfLabels(graphics2D, delta, width);
        for (TimescaleDescriptor desc : TIMESCALE_DESCRIPTORS) {
            if (!desc.match(delta, numLabels)) continue;
            desc.drawLine(graphics2D, delta, start, width);
            break;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        byte[] imageData = baos.toByteArray();
        return Response.ok((Object)imageData).build();
    }

    static {
        int i;
        TIMESCALE_DESCRIPTORS = new ArrayList();
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(60, 12, 1, 13));
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(120, 12, 2, 13));
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(180, 12, 3, 13));
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(240, 12, 4, 13));
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(300, 12, 5, 13));
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(600, 12, 10, 13));
        TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(1800, 12, 30, 13));
        for (i = 1; i <= 10; ++i) {
            TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(3600 * i, 10, i, 13, 12));
        }
        for (i = 1; i <= 10; ++i) {
            TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(86400 * i, 5, i, 13, 12, 10));
        }
        for (i = 1; i <= 10; ++i) {
            TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(2592000 * i, 2, i, 13, 12, 10, 5));
        }
        for (i = 1; i <= 10; ++i) {
            TIMESCALE_DESCRIPTORS.add(new TimescaleDescriptor(31104000 * i, 1, i, 13, 12, 10, 5, 2));
        }
    }

    private static class TimescaleDescriptor {
        private int m_divisor;
        private int m_type;
        private int[] m_typesToZero;
        private int m_increment;
        private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private static final SimpleDateFormat SIMPLE_TIME_FORMAT = new SimpleDateFormat("HH:mm");
        private static final Color ONMS_RED = Color.decode("#e35d5b");
        private static final Color ONMS_GREEN = Color.decode("#99bf73");
        private static final Color ONMS_GRAY = Color.decode("#999999");

        public TimescaleDescriptor(int divisor, int type, int increment, int ... typesToZero) {
            this.m_divisor = divisor;
            this.m_type = type;
            this.m_increment = increment;
            this.m_typesToZero = typesToZero;
        }

        public int getDivisor() {
            return this.m_divisor;
        }

        public int getType() {
            return this.m_type;
        }

        public int[] getTypesToZero() {
            return this.m_typesToZero;
        }

        public int getIncrement() {
            return this.m_increment;
        }

        public boolean match(long delta, int num) {
            return delta / (long)this.m_divisor < (long)num;
        }

        public void drawHeader(Graphics2D graphics2D, long delta, long start, int width) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTimeInMillis(start * 1000L);
            for (int typeToZero : this.getTypesToZero()) {
                calendar.set(typeToZero, calendar.getActualMinimum(typeToZero));
            }
            calendar.add(this.getType(), -this.getIncrement());
            graphics2D.setColor(Color.BLACK);
            while (calendar.getTimeInMillis() / 1000L - (long)this.getDivisor() < start + delta) {
                int n = (int)((calendar.getTimeInMillis() / 1000L - start) / (delta / (long)width));
                graphics2D.setColor(ONMS_GRAY);
                graphics2D.drawLine(n, 16, n, 19);
                graphics2D.drawLine(n, 0, n, 4);
                String d = this.getDivisor() <= 86400 ? SIMPLE_TIME_FORMAT.format(calendar.getTime()) : SIMPLE_DATE_FORMAT.format(calendar.getTime());
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(d, n - graphics2D.getFontMetrics().stringWidth(d) / 2, 15);
                calendar.add(this.getType(), this.getIncrement());
            }
        }

        public void drawLine(Graphics2D graphics2D, long delta, long start, int width) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTimeInMillis(start * 1000L);
            for (int typeToZero : this.getTypesToZero()) {
                calendar.set(typeToZero, calendar.getActualMinimum(typeToZero));
            }
            calendar.add(this.getType(), -this.getIncrement());
            graphics2D.setColor(ONMS_GRAY);
            while (calendar.getTimeInMillis() / 1000L - (long)this.getDivisor() < start + delta) {
                int n = (int)((calendar.getTimeInMillis() / 1000L - start) / (delta / (long)width));
                graphics2D.drawLine(n, 0, n, 19);
                calendar.add(this.getType(), this.getIncrement());
            }
        }

        public boolean drawOutage(Graphics2D graphics2D, long timeDelta, long startTime, int width, OnmsOutage onmsOutage) {
            long outageStartTime = onmsOutage.getIfLostService().getTime() / 1000L;
            long outageEndTime = startTime + timeDelta;
            if (onmsOutage.getIfRegainedService() != null) {
                outageEndTime = onmsOutage.getIfRegainedService().getTime() / 1000L;
            }
            graphics2D.setColor(ONMS_RED);
            int graphicStart = (int)((outageStartTime - startTime) / (timeDelta / (long)width));
            int graphicEnd = (int)((outageEndTime - startTime) / (timeDelta / (long)width));
            graphics2D.fillRect(graphicStart, 2, graphicEnd - graphicStart > 0 ? graphicEnd - graphicStart : 1, 16);
            return onmsOutage.getIfRegainedService() == null;
        }

        public void drawNode(Graphics2D graphics2D, long timeDelta, long startTime, int width, OnmsNode node) {
            long nodeCreateTime = node.getCreateTime().getTime() / 1000L;
            if (nodeCreateTime < startTime) {
                nodeCreateTime = startTime;
            }
            graphics2D.setColor(ONMS_GREEN);
            int graphicStart = (int)((nodeCreateTime - startTime) / (timeDelta / (long)width));
            graphics2D.fillRect(graphicStart, 2, width - graphicStart, 16);
        }

        public static int computeNumberOfLabels(Graphics2D graphics2D, long delta, int width) {
            if (delta <= 86400L) {
                return width / graphics2D.getFontMetrics().stringWidth("XX:XX");
            }
            return width / graphics2D.getFontMetrics().stringWidth("XXXX-XX-XX XX:XX");
        }

        public String getMapEntry(Graphics2D graphics2D, long timeDelta, long startTime, int width, OnmsOutage onmsOutage) {
            long outageStartTime = onmsOutage.getIfLostService().getTime() / 1000L;
            long outageEndTime = startTime + timeDelta;
            if (onmsOutage.getIfRegainedService() != null) {
                outageEndTime = onmsOutage.getIfRegainedService().getTime() / 1000L;
            }
            graphics2D.setColor(ONMS_RED);
            int graphicStart = (int)((outageStartTime - startTime) / (timeDelta / (long)width));
            int graphicEnd = (int)((outageEndTime - startTime) / (timeDelta / (long)width));
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append("<area shape=\"rect\" coords=\"");
            stringBuffer.append(graphicStart);
            stringBuffer.append(",2,");
            stringBuffer.append(graphicEnd);
            stringBuffer.append(",18\" ");
            stringBuffer.append("href=\"/opennms/outage/detail.htm?id=");
            stringBuffer.append(onmsOutage.getId());
            stringBuffer.append("\" alt=\"Id " + onmsOutage.getId() + "\" title=\"" + onmsOutage.getIfLostService() + "\">");
            return stringBuffer.toString();
        }
    }
}

