/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.InetAddress;
import javax.annotation.PreDestroy;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpConfigAccessService;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.model.SnmpInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="snmpConfigRestService")
@Path(value="snmpConfig")
@Tag(name="SnmpConfig", description="SNMP Config API")
@Transactional
public class SnmpConfigRestService
extends OnmsRestService {
    @Autowired
    private SnmpConfigAccessService m_accessService;

    @PreDestroy
    protected void tearDown() {
        if (this.m_accessService != null) {
            this.m_accessService.flushAll();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{ipAddr}")
    public SnmpInfo getSnmpInfo(@PathParam(value="ipAddr") String ipAddr, @QueryParam(value="location") String location) {
        InetAddress addr = InetAddressUtils.addr((String)ipAddr);
        if (addr == null) {
            throw SnmpConfigRestService.getException(Response.Status.BAD_REQUEST, "Malformed IP Address: {}.", ipAddr);
        }
        SnmpAgentConfig config = this.m_accessService.getAgentConfig(addr, location);
        return new SnmpInfo(config);
    }

    @PUT
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{ipAddr}")
    public Response setSnmpInfo(@PathParam(value="ipAddr") String ipAddress, SnmpInfo snmpInfo) {
        this.writeLock();
        try {
            SnmpEventInfo eventInfo;
            if (ipAddress.contains("-")) {
                String[] addrs = SnmpConfigRestService.getAddresses(ipAddress);
                eventInfo = snmpInfo.createEventInfo(addrs[0], addrs[1]);
            } else {
                eventInfo = snmpInfo.createEventInfo(ipAddress);
            }
            this.m_accessService.define(eventInfo);
            Response response = Response.noContent().build();
            return response;
        }
        catch (Throwable e) {
            throw SnmpConfigRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't update SNMP configuration for {} : {}", ipAddress, e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{ipAddr}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateInterface(@PathParam(value="ipAddr") String ipAddress, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            SnmpEventInfo eventInfo;
            SnmpInfo info = new SnmpInfo();
            SnmpConfigRestService.setProperties(params, info);
            if (ipAddress.contains("-")) {
                String[] addrs = SnmpConfigRestService.getAddresses(ipAddress);
                eventInfo = info.createEventInfo(addrs[0], addrs[1]);
            } else {
                eventInfo = info.createEventInfo(ipAddress);
            }
            this.m_accessService.define(eventInfo);
            Response response = Response.noContent().build();
            return response;
        }
        catch (Throwable e) {
            throw SnmpConfigRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't update SNMP configuration for {} : {}", ipAddress, e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    protected static String[] getAddresses(String input) {
        if (input == null || input.trim().isEmpty()) {
            return new String[]{null, null};
        }
        return input.trim().split("-", 2);
    }
}

