/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.netmgt.snmp.SnmpException;
import org.opennms.netmgt.snmp.SnmpVarBindDTO;
import org.opennms.netmgt.snmp.TrapIdentity;

public abstract class TrapInformation {
    private final InetAddress m_agent;
    private final String m_community;
    private long m_creationTime = new Date().getTime();
    private String systemId;
    private String location;

    protected TrapInformation(InetAddress agent, String community) {
        this.m_agent = agent;
        this.m_community = community;
    }

    public abstract InetAddress getTrapAddress();

    public final String getSystemId() {
        return this.systemId;
    }

    public final void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public final String getLocation() {
        return this.location;
    }

    public final void setLocation(String location) {
        this.location = location;
    }

    public final String getCommunity() {
        return this.m_community;
    }

    public void validate() throws SnmpException {
    }

    public final InetAddress getAgentAddress() {
        return this.m_agent;
    }

    public final long getCreationTime() {
        return this.m_creationTime;
    }

    public final void setCreationTime(long creationTime) {
        this.m_creationTime = creationTime;
    }

    public abstract String getVersion();

    public abstract int getPduLength();

    public abstract long getTimeStamp();

    public abstract TrapIdentity getTrapIdentity();

    protected abstract Integer getRequestId();

    public abstract SnmpVarBindDTO getSnmpVarBindDTO(int var1);
}

