/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.common;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.scheduler.Executable;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;

public abstract class NodeCollector
extends Executable {
    protected final Node m_node;
    private final LocationAwareSnmpClient m_loLocationAwareSnmpClient;

    public NodeCollector(LocationAwareSnmpClient snmpClient, Node node, int priority) {
        super(priority);
        this.m_node = node;
        this.m_loLocationAwareSnmpClient = snmpClient;
    }

    public abstract void collect();

    public void runExecutable() {
        this.collect();
    }

    public InetAddress getPrimaryIpAddress() {
        return this.m_node.getSnmpPrimaryIpAddr();
    }

    public String getPrimaryIpAddressString() {
        return InetAddressUtils.str((InetAddress)this.m_node.getSnmpPrimaryIpAddr());
    }

    public String getInfo() {
        return this.getName() + " node:[" + this.getNodeId() + "] ip:" + InetAddressUtils.str((InetAddress)this.getPrimaryIpAddress()) + super.getInfo();
    }

    public int getNodeId() {
        return this.m_node.getNodeId();
    }

    public String getSysoid() {
        return this.m_node.getSysoid();
    }

    public String getSysname() {
        return this.m_node.getSysname();
    }

    public String getLocation() {
        return this.m_node.getLocation();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_node == null ? 0 : this.m_node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NodeCollector other = (NodeCollector)((Object)obj);
        if (this.m_node == null) {
            return other.m_node == null;
        }
        return this.m_node.equals((Object)other.m_node);
    }

    public SnmpAgentConfig getSnmpAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.m_node.getSnmpPrimaryIpAddr(), this.m_node.getLocation());
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_loLocationAwareSnmpClient;
    }

    public Node getNode() {
        return this.m_node;
    }

    public boolean isReady() {
        return true;
    }
}

