/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.commands;

import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.events.commands.EventUeiCompleter;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAlarmCollection;

@Command(scope="opennms", name="alarm-list", description="Lists current alarms meeting certain criteria")
@Service
public class AlarmListCommand
implements Action {
    @Reference
    AlarmDao alarmDao;
    @Option(name="-l", aliases={"--limit"}, description="Limit the number of alarms that are shown.")
    int limit = 10;
    @Argument(name="uei", description="Event UEI to match (exact).", required=false, multiValued=false)
    @Completion(value=EventUeiCompleter.class)
    String eventUeiMatch;

    public Object execute() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class).orderBy("lastEventTime").desc().limit(Integer.valueOf(this.limit)).alias("node", "node", Alias.JoinType.LEFT_JOIN);
        if (!Strings.isNullOrEmpty((String)this.eventUeiMatch)) {
            criteriaBuilder.eq("uei", (Object)this.eventUeiMatch);
        }
        OnmsAlarmCollection alarmCollection = new OnmsAlarmCollection((Collection)this.alarmDao.findMatching(criteriaBuilder.toCriteria()));
        alarmCollection.setTotalCount(Integer.valueOf(this.alarmDao.countMatching(criteriaBuilder.toCriteria())));
        System.out.println(String.format("Found %d alarms, showing %d:", alarmCollection.getTotalCount(), alarmCollection.size()));
        try {
            ShellTable table = new ShellTable();
            table.column("ID");
            table.column("Count");
            table.column("UEI");
            table.column("Severity");
            table.column("Last Event Time");
            table.column("Node Label");
            table.column("Ack User");
            table.column("Ack Time");
            for (OnmsAlarm alarm : alarmCollection) {
                table.addRow().addContent(new Object[]{alarm.getId(), alarm.getCounter(), alarm.getUei(), alarm.getSeverityLabel(), alarm.getLastEventTime(), alarm.getNodeLabel(), alarm.getAlarmAckUser(), alarm.getAlarmAckTime()});
            }
            table.print(System.out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
        return null;
    }
}

