/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.util;

import com.atlassian.oai.validator.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HttpParsingUtils {
    private HttpParsingUtils() {
    }

    public static boolean isMultipartContentTypeAcceptedByConsumer(@Nonnull String requestContentType, @Nonnull String consumesContentType) {
        if (!requestContentType.startsWith("multipart/") || !consumesContentType.startsWith("multipart/")) {
            return false;
        }
        Optional<String> consumesContentTypeBoundary = HttpParsingUtils.extractMultipartBoundary(consumesContentType);
        if (consumesContentTypeBoundary.isPresent()) {
            return requestContentType.trim().equals(consumesContentType.trim().toLowerCase());
        }
        return requestContentType.trim().toLowerCase().startsWith(consumesContentType.trim().toLowerCase());
    }

    @Nonnull
    public static Optional<String> extractMultipartBoundary(@Nonnull String multipartContentType) {
        String[] split = multipartContentType.split("=", 2);
        if (split.length < 2) {
            return Optional.empty();
        }
        return Optional.of(split[1]);
    }

    @Nonnull
    public static Multimap<String, String> parseMultipartFormDataBody(@Nonnull String multipartContentTypeWithBoundary, @Nonnull String httpBody) {
        ArrayListMultimap params = ArrayListMultimap.create();
        Optional<String> maybeBoundary = HttpParsingUtils.extractMultipartBoundary(multipartContentTypeWithBoundary);
        if (!maybeBoundary.isPresent() && httpBody.isEmpty()) {
            return params;
        }
        String boundary = maybeBoundary.get();
        String wrappedHttpBody = StringUtils.addOpeningAndTrailingNewlines(httpBody, true);
        if (!wrappedHttpBody.endsWith("\r\n--" + boundary + "--\r\n")) {
            return params;
        }
        String[] bodyChunks = wrappedHttpBody.split("\r\n--" + boundary + "\r\n");
        if (!bodyChunks[0].isEmpty()) {
            return params;
        }
        for (String chunk : bodyChunks) {
            String[] headerBody = chunk.split("\r\n\r\n", 2);
            Optional<String> maybeChunkName = HttpParsingUtils.extractFormDataName(headerBody[0]);
            maybeChunkName.ifPresent(arg_0 -> HttpParsingUtils.lambda$parseMultipartFormDataBody$0((Multimap)params, headerBody, boundary, arg_0));
        }
        return params;
    }

    @Nonnull
    public static Multimap<String, String> parseUrlEncodedFormDataBody(@Nonnull String httpBody) {
        ArrayListMultimap params = ArrayListMultimap.create();
        String[] pairs = httpBody.split("&");
        try {
            for (String pair : pairs) {
                String[] fields = pair.split("=");
                String name = URLDecoder.decode(fields[0], Charsets.UTF_8.name()).trim();
                String value = fields.length > 1 ? URLDecoder.decode(fields[1], Charsets.UTF_8.name()) : null;
                params.put((Object)name, (Object)value);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return params;
    }

    private static Optional<String> extractFormDataName(String multipartBodyChunkHeader) {
        String[] lines;
        for (String line : lines = multipartBodyChunkHeader.split("\r\n\r\n")) {
            if (!line.toLowerCase().startsWith("content-disposition: form-data; name=\"")) continue;
            String[] splitLine = line.split("\"", 3);
            return Optional.of(splitLine[1]);
        }
        return Optional.empty();
    }

    @Nonnull
    public static JsonNode parseUrlEncodedFormDataBodyAsJsonNode(@Nonnull String httpBody) {
        Multimap<String, String> data = HttpParsingUtils.parseUrlEncodedFormDataBody(httpBody);
        ObjectNode root = new ObjectNode(JsonNodeFactory.instance);
        data.asMap().forEach((key, values) -> root.set(key, HttpParsingUtils.toJsonObject(values)));
        return root;
    }

    @Deprecated
    @Nonnull
    public static String parseUrlEncodedFormDataBodyAsJson(@Nonnull String httpBody) {
        return HttpParsingUtils.parseUrlEncodedFormDataBodyAsJsonNode(httpBody).toString();
    }

    private static JsonNode toJsonObject(Collection<String> values) {
        if (values.size() == 0) {
            return NullNode.getInstance();
        }
        if (values.size() == 1) {
            return HttpParsingUtils.toJsonObject(values.iterator().next());
        }
        return new ArrayNode(JsonNodeFactory.instance, values.stream().map(HttpParsingUtils::toJsonObject).collect(Collectors.toList()));
    }

    private static JsonNode toJsonObject(@Nullable String value) {
        if (value == null || value.equalsIgnoreCase("null")) {
            return NullNode.getInstance();
        }
        String trimmed = value.trim();
        if (trimmed.equalsIgnoreCase("false")) {
            return BooleanNode.getFalse();
        }
        if (trimmed.equalsIgnoreCase("true")) {
            return BooleanNode.getTrue();
        }
        try {
            return new LongNode(Long.parseLong(trimmed));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new DoubleNode(Double.parseDouble(trimmed));
            }
            catch (NumberFormatException numberFormatException2) {
                return new TextNode(trimmed);
            }
        }
    }

    private static /* synthetic */ void lambda$parseMultipartFormDataBody$0(Multimap params, String[] headerBody, String boundary, String chunkName) {
        params.put((Object)chunkName, (Object)headerBody[1].replace("\r\n--" + boundary + "--\r\n", ""));
    }
}

