/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.transform;

import com.atlassian.oai.validator.schema.transform.SchemaTransformationContext;
import com.atlassian.oai.validator.schema.transform.SchemaTransformer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.stream.Collectors;

public class RequiredFieldTransformer
extends SchemaTransformer {
    private static final RequiredFieldTransformer INSTANCE = new RequiredFieldTransformer();

    public static RequiredFieldTransformer getInstance() {
        return INSTANCE;
    }

    @Override
    public void apply(JsonNode schemaObject, SchemaTransformationContext context) {
        if (schemaObject == null) {
            return;
        }
        if (!context.isRequest() && !context.isResponse()) {
            return;
        }
        if (RequiredFieldTransformer.hasRequiredFields(schemaObject)) {
            List<String> adjustedRequired = RequiredFieldTransformer.getRequiredFieldNames(schemaObject).stream().filter(fieldName -> this.isNotReadOnlyInRequest(context, schemaObject, (String)fieldName) || this.isNotWriteOnlyInResponse(context, schemaObject, (String)fieldName)).collect(Collectors.toList());
            RequiredFieldTransformer.setRequiredFieldNames(schemaObject, adjustedRequired);
        }
        RequiredFieldTransformer.applyToChildSchemas(schemaObject, child -> this.apply((JsonNode)child, context));
    }

    private boolean isNotWriteOnlyInResponse(SchemaTransformationContext context, JsonNode schemaObject, String fieldName) {
        return context.isResponse() && !RequiredFieldTransformer.isWriteOnly(RequiredFieldTransformer.property(schemaObject, fieldName));
    }

    private boolean isNotReadOnlyInRequest(SchemaTransformationContext context, JsonNode schemaObject, String fieldName) {
        return context.isRequest() && !RequiredFieldTransformer.isReadOnly(RequiredFieldTransformer.property(schemaObject, fieldName));
    }
}

