/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class FloatAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new FloatAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private FloatAttribute() {
        super("float", NodeType.NUMBER, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String parsed;
        JsonNode instance = data.getInstance().getNode();
        float f = instance.floatValue();
        String original = String.valueOf(instance.decimalValue());
        if (!original.equals(parsed = String.valueOf(f))) {
            report.error(this.newMsg(data, bundle, "err.format.float.overflow").put("key", "err.format.float.overflow").putArgument("value", (Object)original).putArgument("converted", (Object)parsed));
        }
    }
}

