/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.util.StringUtils;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ImmutableMessage
implements ValidationReport.Message {
    private final String key;
    private final ValidationReport.Level level;
    private final String message;
    private final List<String> additionalInfo;
    private final List<ValidationReport.Message> nestedMessages;
    @Nullable
    private final ValidationReport.MessageContext context;

    ImmutableMessage(@Nonnull String key, @Nonnull ValidationReport.Level level, @Nonnull String message, String ... additionalInfo) {
        this(key, level, message, Arrays.asList(additionalInfo), null);
    }

    ImmutableMessage(@Nonnull String key, @Nonnull ValidationReport.Level level, @Nonnull String message, @Nonnull List<String> additionalInfo, @Nullable ValidationReport.MessageContext context) {
        this(key, level, message, additionalInfo, Collections.emptyList(), context);
    }

    ImmutableMessage(@Nonnull String key, @Nonnull ValidationReport.Level level, @Nonnull String message, @Nonnull List<String> additionalInfo, @Nonnull List<ValidationReport.Message> nestedMessages, @Nullable ValidationReport.MessageContext context) {
        this.key = Objects.requireNonNull(key, "A key is required");
        this.level = Objects.requireNonNull(level, "A level is required");
        this.message = Objects.requireNonNull(message, "A message is required");
        this.additionalInfo = Collections.unmodifiableList(Objects.requireNonNull(additionalInfo));
        this.nestedMessages = Collections.unmodifiableList(Objects.requireNonNull(nestedMessages));
        this.context = context;
    }

    @Override
    public ValidationReport.Message withLevel(ValidationReport.Level level) {
        return new ImmutableMessage(this.key, level, this.message, this.additionalInfo.toArray(new String[this.additionalInfo.size()]));
    }

    @Override
    public ValidationReport.Message withAdditionalInfo(String info) {
        return new ImmutableMessage(this.key, this.level, this.message, (List<String>)ImmutableList.builder().addAll(this.additionalInfo).add((Object)info).build(), this.nestedMessages, this.context);
    }

    @Override
    public ValidationReport.Message withNestedMessages(Collection<ValidationReport.Message> messages) {
        Collection<ValidationReport.Message> newMessages = messages != null ? messages : Collections.emptyList();
        return new ImmutableMessage(this.key, this.level, this.message, this.additionalInfo, (List<ValidationReport.Message>)ImmutableList.builder().addAll(this.nestedMessages).addAll(newMessages).build(), this.context);
    }

    @Override
    public ValidationReport.Message withAdditionalContext(ValidationReport.MessageContext context) {
        ValidationReport.MessageContext newContext = this.context == null ? context : this.context.enhanceWith(context);
        return new ImmutableMessage(this.key, this.level, this.message, this.additionalInfo, this.nestedMessages, newContext);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ValidationReport.Level getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return (Object)((Object)this.level) + " - " + this.message.replace("\n", "\n\t") + ": [" + this.additionalInfo.stream().collect(Collectors.joining(", ")) + "]" + this.nestedMessages.stream().map(message -> "\n" + StringUtils.indentString(message.toString(), "\t")).collect(Collectors.joining());
    }

    @Override
    public List<String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public List<ValidationReport.Message> getNestedMessages() {
        return this.nestedMessages;
    }

    @Override
    public Optional<ValidationReport.MessageContext> getContext() {
        return Optional.ofNullable(this.context);
    }
}

