/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.xml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParserException;
import org.xml.sax.Attributes;

public class XMLPullParser {
    public static final int ATTRIBUTE = 10;
    public static final int CDATA = 12;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 5;
    public static final int DTD = 11;
    public static final String EMPTY = "";
    public static final int END_DOCUMENT = 8;
    public static final int END_ELEMENT = 2;
    public static final int ENTITY_DECLARATION = 15;
    public static final int ENTITY_REFERENCE = 9;
    public static final int NAMESPACE = 13;
    public static final int NOTATION_DECLARATION = 14;
    public static final int PROCESSING_INSTRUCTION = 3;
    public static final int SPACE = 6;
    public static final int START_DOCUMENT = 7;
    public static final int START_ELEMENT = 1;
    Vector iAttributeNames = new Vector();
    Attributes iAttributes;
    Vector iAttributeValues = new Vector();
    byte[] iBuffer;
    char[] iBufferChar = null;
    XMLAttributeValue iCharacters;
    boolean iClosingElementNamePending;
    int iColNumber = 1;
    int iCurrentPosition = 0;
    int iCurrentState = 0;
    String iElementName;
    Vector iElementNames = new Vector();
    int iEndCharacters;
    int iFinish;
    int iFinishChar = 0;
    Reader iInstream;
    int iLineNumber = 1;
    char iNextChar;
    boolean iSeenEpilog;
    boolean iSeenProlog;
    int iStart;
    int iStartCharacters;
    int iTotalAttributes;

    public static void main(String[] args) {
        try {
            File[] xmlFiles = XMLDefaultHandlerImpl.listAllXml(new File("c:\\code\\cimxml\\"));
            xmlFiles = new File[]{new File("c:\\code\\cimxml\\Response_EnumerateInstances_Brocade_PortInSwitch.xml")};
            for (int i = 0; i < xmlFiles.length; ++i) {
                XMLDefaultHandlerImpl parserHdlr = new XMLDefaultHandlerImpl(false);
                System.out.println("\n" + i + " - " + xmlFiles[i].getAbsolutePath());
                XMLPullParser reader = new XMLPullParser(new InputStreamReader(new FileInputStream(xmlFiles[i])));
                try {
                    while (XMLPullParser.next(reader, parserHdlr)) {
                        Vector v;
                        Vector o = parserHdlr.getObjects();
                        CIMResponse response = (CIMResponse)o.elementAt(0);
                        try {
                            response.checkError();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if ((v = response.getFirstReturnValue()).size() <= 0) continue;
                        System.out.println(v.remove(0));
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    parserHdlr = new XMLDefaultHandlerImpl(true);
                    System.out.println("\n" + i + " - " + xmlFiles[i].getAbsolutePath());
                    reader = new XMLPullParser(new InputStreamReader(new FileInputStream(xmlFiles[i])));
                    while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                parserHdlr.startElement(EMPTY, EMPTY, reader.getElementName(), reader.getAttributes());
                                break;
                            }
                            case 2: {
                                parserHdlr.endElement(EMPTY, EMPTY, reader.getElementName());
                                break;
                            }
                            case 4: {
                                char[] buf = reader.getText().toCharArray();
                                parserHdlr.characters(buf, 0, buf.length);
                            }
                        }
                    }
                    CIMResponse response = (CIMResponse)parserHdlr.getObjects().elementAt(0);
                    System.out.println("done\n" + response.getFirstReturnValue());
                    e.printStackTrace();
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean next(XMLPullParser reader, XMLDefaultHandlerImpl parserHdlr) throws Exception {
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    parserHdlr.startElement(EMPTY, EMPTY, reader.getElementName(), reader.getAttributes());
                    break;
                }
                case 2: {
                    parserHdlr.endElement(EMPTY, EMPTY, reader.getElementName());
                    String lastElementName = null;
                    if (reader.getElementNames().size() > 0) {
                        lastElementName = (String)reader.getElementNames().lastElement();
                    }
                    if (lastElementName == null || !lastElementName.equalsIgnoreCase("IRETURNVALUE")) break;
                    return true;
                }
                case 4: {
                    char[] buf = reader.getText().toCharArray();
                    parserHdlr.characters(buf, 0, buf.length);
                    break;
                }
                case 8: {
                    return false;
                }
            }
        }
        return false;
    }

    public XMLPullParser(Reader in) {
        this.iInstream = in;
        this.reset();
    }

    public void close() {
    }

    public Attributes getAttributes() {
        if (this.iCurrentState != 1) {
            return null;
        }
        if (this.iAttributes == null) {
            this.iAttributes = new XMLAttributes();
        }
        return this.iAttributes;
    }

    public String getElementName() {
        return this.iElementName;
    }

    public Vector getElementNames() {
        return this.iElementNames;
    }

    public int getLevel() {
        return this.iElementNames.size();
    }

    public String getText() {
        String result = null;
        if (this.iCurrentState == 4 && this.iCharacters != null) {
            return this.iCharacters.getText();
        }
        return result;
    }

    public boolean hasNext() {
        return this.iCurrentState != 8;
    }

    public int next() throws IOException {
        int hash;
        this.resetAttributes();
        this.ensureCapacity();
        if (this.iClosingElementNamePending) {
            this.iClosingElementNamePending = false;
            this.iElementNames.remove(this.iElementNames.size() - 1);
            this.iCurrentState = 2;
            return this.iCurrentState;
        }
        while (true) {
            char ch;
            if ((ch = (char)this.getNextCharCheckingEOF()) == '<') {
                ch = (char)this.getNextChar();
                if (ch == '?') {
                    if (this.iSeenProlog) {
                        throw new XMLPullParserException("The processing instruction target matching \"[xX][mM][lL]\" is not allowed.");
                    }
                    this.iSeenProlog = true;
                    this.parsePI();
                    ch = (char)this.getNextChar();
                    ch = this.skipOptionalSpaces(ch);
                    if (ch != '<') {
                        throw new XMLPullParserException(this, "Content is not allowed in prolog.");
                    }
                    this.goBack();
                    this.iCurrentState = 7;
                    return this.iCurrentState;
                }
                if (ch == '!') {
                    ch = (char)this.getNextChar();
                    if (ch == '-') {
                        this.parseComment();
                        this.iCurrentState = 5;
                        return this.iCurrentState;
                    }
                    if (ch == '[') {
                        this.parseCDATA();
                        this.iCurrentState = 4;
                        return this.iCurrentState;
                    }
                    throw new XMLPullParserException(this, "unexpected char " + this.escape(ch));
                }
                if (ch == '/') {
                    this.parseEndElement();
                    this.iCurrentState = 2;
                    return this.iCurrentState;
                }
                if (ch == '&') {
                    this.parseUnknown();
                    continue;
                }
                if (this.isValidStartElementNameChar(ch)) {
                    if (!this.iSeenProlog) {
                        this.iSeenProlog = true;
                        this.iCurrentState = 7;
                        this.goBack();
                        this.goBack();
                        return this.iCurrentState;
                    }
                    this.parseStartElement(ch);
                    this.iCurrentState = 1;
                    return this.iCurrentState;
                }
                throw new XMLPullParserException(this, "unexpected char " + this.escape(ch));
            }
            this.iStartCharacters = this.iCurrentPosition - 1;
            boolean amp = false;
            hash = 0;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == '\uffff') {
                    if (this.iElementNames.size() != 0) {
                        throw new XMLPullParserException(this, "unexpected EOF ");
                    }
                    this.iCurrentState = 8;
                    return this.iCurrentState;
                }
                if (ch != '\r' && ch != '\n' && !this.isSpace(ch) && ch != '<' && this.iElementNames.size() == 0) {
                    if (!this.iSeenProlog) {
                        throw new XMLPullParserException(this, "Content is not allowed in trailing section.");
                    }
                    throw new XMLPullParserException(this, "Content is not allowed in trailing section.");
                }
                amp = false;
                if (ch != '&') continue;
                amp = true;
                int i = this.parseReference();
                ch = (char)(i & 0xFFFF);
            } while (ch != '<' || amp);
            this.iEndCharacters = this.iCurrentPosition;
            this.goBack();
            if (this.iElementNames.size() > 0) break;
        }
        if (this.iCharacters == null) {
            this.iCharacters = new XMLAttributeValue(this.iStartCharacters, this.iEndCharacters - this.iStartCharacters - 1, hash);
        } else {
            this.iCharacters.init(this.iStartCharacters, this.iEndCharacters - this.iStartCharacters - 1);
            this.iCharacters.setTranslate(true, hash);
        }
        this.iCurrentState = 4;
        return this.iCurrentState;
    }

    public void reset() {
        this.iSeenProlog = true;
        this.iCurrentState = 0;
        this.iClosingElementNamePending = false;
        this.iColNumber = 1;
        this.iLineNumber = 1;
        this.iElementName = null;
        this.iElementNames.setSize(0);
        this.iAttributeNames.setSize(0);
        this.iAttributeValues.setSize(0);
        this.iAttributes = null;
        this.iStartCharacters = 0;
        this.iEndCharacters = 0;
        this.iTotalAttributes = 0;
        this.iSeenProlog = false;
        this.iSeenEpilog = false;
    }

    public String toString() {
        switch (this.iCurrentState) {
            case 1: {
                String s = "START ELEM: <" + this.iElementName;
                if (this.iAttributeNames.size() > 0) {
                    s = s + " ";
                    for (int i = 0; i < this.iAttributeNames.size(); ++i) {
                        s = s + this.iAttributeNames.elementAt(i) + "=\"" + this.iAttributeValues.elementAt(i) + "\" ";
                    }
                }
                s = s + ">";
                return s;
            }
            case 2: {
                String s = "END ELEM: </" + this.iElementName + ">";
                return s;
            }
            case 4: {
                return "CHARACTERS: \"" + this.getText();
            }
        }
        return "UNKOWN";
    }

    protected char _getNextChar() {
        return '\uffff';
    }

    protected void addAttribute(int begName, int lenName, int begValue, int lenValue, int hashname, int hashvalue) {
        if (this.iAttributeNames.size() > this.iTotalAttributes) {
            XMLAttributeValue attribute = (XMLAttributeValue)this.iAttributeValues.elementAt(this.iTotalAttributes);
            XMLAttributeValue name = (XMLAttributeValue)this.iAttributeNames.elementAt(this.iTotalAttributes);
            ++this.iTotalAttributes;
            attribute.init(begValue, lenValue);
            attribute.setTranslate(true, hashvalue);
            name.init(begName, lenName);
            name.setTranslate(false, hashname);
        } else {
            XMLAttributeValue attribute = new XMLAttributeValue(begValue, lenValue, hashvalue);
            XMLAttributeValue name = new XMLAttributeValue(begName, lenName, false, hashname);
            ++this.iTotalAttributes;
            this.iAttributeNames.add(name);
            this.iAttributeValues.add(attribute);
        }
    }

    protected void ensureCapacity() {
        if (this.iBufferChar == null) {
            this.iBufferChar = new char[1024];
        }
        if (this.iCurrentPosition >= 8 * this.iBufferChar.length / 10) {
            System.arraycopy(this.iBufferChar, this.iCurrentPosition, this.iBufferChar, 0, this.iFinishChar - this.iCurrentPosition);
            this.iFinishChar -= this.iCurrentPosition;
            this.iCurrentPosition = 0;
        }
    }

    protected String escape(char ch) {
        String string;
        if (ch == '\n') {
            string = "'\\n'";
        }
        if (ch == '\r') {
            string = "'\\r'";
        }
        if (ch == '\t') {
            string = "'\\t'";
        }
        if (ch == '\'') {
            string = "'\\''";
        }
        String result = ch > '\u007f' || ch < ' ' ? "'\\u" + Integer.toHexString(ch) + "'" : "'" + ch + "'";
        return result;
    }

    protected int getChar() throws IOException {
        if (this.iFinishChar <= this.iCurrentPosition) {
            if (this.iBufferChar == null) {
                this.iBufferChar = new char[1024];
            } else if (this.iFinishChar >= this.iBufferChar.length) {
                char[] tmp = this.iBufferChar;
                this.iBufferChar = new char[this.iBufferChar.length << 1];
                System.arraycopy(tmp, 0, this.iBufferChar, 0, tmp.length);
            }
            int total = this.iInstream.read(this.iBufferChar, this.iFinishChar, this.iBufferChar.length - this.iFinishChar);
            if (total <= 0) {
                return -1;
            }
            this.iFinishChar += total;
        }
        return this.iBufferChar[this.iCurrentPosition++];
    }

    protected int getNextChar() throws IOException {
        int ch = this.iFinishChar <= this.iCurrentPosition ? this.getChar() : this.iBufferChar[this.iCurrentPosition++];
        if (ch == -1) {
            throw new XMLPullParserException(this, "unexpected end of document");
        }
        if (ch == 10) {
            ++this.iLineNumber;
            this.iColNumber = 1;
        } else {
            ++this.iColNumber;
        }
        return (char)ch;
    }

    protected int getNextCharCheckingEOF() throws IOException {
        int ch = this.iFinishChar <= this.iCurrentPosition ? this.getChar() : this.iBufferChar[this.iCurrentPosition++];
        if (ch == 10) {
            ++this.iLineNumber;
            this.iColNumber = 1;
        } else {
            ++this.iColNumber;
        }
        return (char)ch;
    }

    protected void goBack() {
        --this.iCurrentPosition;
        if (this.iColNumber > 1) {
            --this.iColNumber;
        }
    }

    protected boolean isSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    protected boolean isValidElementNameChar(char ch) {
        return ch < '\u0100' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == ':' || ch == '-' || ch == '.' || ch >= '0' && ch <= '9' || ch == '\u00b7') || ch >= '\u00c0' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u0300' && ch <= '\u036f' || ch >= '\u037f' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isValidStartElementNameChar(char ch) {
        return ch < '\u0100' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == ':') || ch >= '\u00c0' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u0400' || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected void parseAttribute(char ch) throws IOException {
        int startAttributeName = this.iCurrentPosition - 1;
        int hash = 0;
        while (this.isValidElementNameChar(ch = (char)this.getNextChar())) {
        }
        int endAttributeName = this.iCurrentPosition;
        if ((ch = this.skipOptionalSpaces(ch)) != '=') {
            throw new XMLPullParserException(this, "missing chacter '='instead " + this.escape(ch) + " was found ");
        }
        ch = (char)this.getNextChar();
        if ((ch = this.skipOptionalSpaces(ch)) != '\"' && ch != '\'') {
            throw new XMLPullParserException(this, "missing chacter '\"' or ''' instead " + this.escape(ch) + " was found ");
        }
        char delimiter = ch;
        int startAttributeValue = this.iCurrentPosition;
        char prevCh = '\u0000';
        int hashvalue = 0;
        while ((ch = (char)this.getNextChar()) != delimiter) {
            if (ch == '<' || ch == '>') {
                throw new XMLPullParserException(this, "illegal character " + this.escape(ch));
            }
            if (ch == '&') {
                int ref = this.parseReference();
                ch = (char)(ref & 0xFFFF);
            } else if (ch != '\t' && ch != '\r' && ch != '\n' || ch != '\n' || prevCh != '\r') {
                // empty if block
            }
            prevCh = ch;
        }
        int endAttributeValue = this.iCurrentPosition;
        this.addAttribute(startAttributeName, endAttributeName - startAttributeName - 1, startAttributeValue, endAttributeValue - startAttributeValue - 1, hash, hashvalue);
    }

    protected int parseCDATA() throws IOException {
        int startCharacter;
        block9: {
            char ch = (char)this.getNextChar();
            if (ch != 'C') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'D') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'A') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'T') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'A') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != '[') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            boolean braketFound = false;
            boolean doubleBraket = false;
            startCharacter = this.iCurrentPosition;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == ']') {
                    if (braketFound) {
                        doubleBraket = true;
                    }
                    braketFound = true;
                    continue;
                }
                if (ch == '>' && doubleBraket) break block9;
                braketFound = false;
                doubleBraket = false;
            } while (ch != '\uffff');
            throw new XMLPullParserException("XML document structures must start and end within the same entity.");
        }
        int endCharacter = this.iCurrentPosition - 1;
        this.iCharacters.setTranslate(false, 0);
        this.iCharacters.init(startCharacter, endCharacter - startCharacter);
        return -1;
    }

    protected int parseComment() throws IOException {
        block4: {
            char ch = (char)this.getNextChar();
            if (ch != '-') {
                throw new XMLPullParserException("Comment must start with \"<!--\".");
            }
            boolean dashFound = false;
            boolean doubleDash = false;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == '-') {
                    if (dashFound) {
                        doubleDash = true;
                    }
                    dashFound = true;
                    continue;
                }
                if (ch == '>' && doubleDash) break block4;
                dashFound = false;
                doubleDash = false;
            } while (ch != '\uffff');
            throw new XMLPullParserException("XML document structures must start and end within the same entity.");
        }
        return -1;
    }

    protected void parseEndElement() throws IOException {
        char ch;
        int startElementName = this.iCurrentPosition;
        while (this.isValidElementNameChar(ch = (char)this.getNextChar())) {
        }
        int endElementName = this.iCurrentPosition;
        this.iElementName = new String(this.iBufferChar, startElementName, endElementName - startElementName - 1);
        if (!this.iElementNames.lastElement().equals(this.iElementName.toUpperCase())) {
            throw new XMLPullParserException(this, "The content of elements must consist of well-formed character data or markup.");
        }
        this.iElementNames.remove(this.iElementNames.size() - 1);
        ch = this.skipOptionalSpaces(ch);
        if (ch != '>') {
            throw new XMLPullParserException(this, "'=' was expected, but '" + this.escape(ch) + "' was found instead");
        }
        if (this.iElementNames.size() == 0) {
            this.iSeenEpilog = true;
        }
    }

    protected int parsePI() throws IOException {
        block2: {
            char ch = (char)this.getNextChar();
            boolean dashFound = false;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == '?') {
                    dashFound = true;
                    continue;
                }
                if (ch == '>' && dashFound) break block2;
                dashFound = false;
            } while (ch != '\uffff');
            throw new XMLPullParserException("XML document structures must start and end within the same entity.");
        }
        return -1;
    }

    protected int parseReference() throws IOException {
        char ch1 = (char)this.getNextChar();
        if (ch1 == '#') {
            ch1 = (char)this.getNextChar();
            if (ch1 == 'x') {
                int value = 0;
                while (true) {
                    if ((ch1 = (char)this.getNextChar()) >= '0' && ch1 <= '9') {
                        value = value * 16 + (ch1 - 48);
                        continue;
                    }
                    if ((ch1 < 'A' || ch1 > 'F') && (ch1 < 'a' || ch1 > 'z')) break;
                    value = value * 16 + (Character.toUpperCase(ch1) - 65 + 10);
                }
                if (ch1 != ';') {
                    throw new XMLPullParserException(this, "invalid character while parsing hex encoded number " + this.escape(ch1));
                }
                return (char)value;
            }
            int value = 0;
            if (ch1 >= '0' && ch1 <= '9') {
                while (ch1 >= '0' && ch1 <= '9') {
                    value = value * 10 + (ch1 - 48);
                    ch1 = (char)this.getNextChar();
                }
                if (ch1 != ';') {
                    throw new XMLPullParserException(this, "invalid character while parsing decinal encoded character: " + this.escape(ch1));
                }
                return (char)value;
            }
            throw new XMLPullParserException(this, "invalid number format");
        }
        int startPos = this.iCurrentPosition - 1;
        if (this.isValidStartElementNameChar(ch1)) {
            while ((ch1 = (char)this.getNextChar()) != ';') {
                if (this.isValidElementNameChar(ch1)) continue;
                throw new XMLPullParserException("invalid reference character " + this.escape(ch1));
            }
        } else {
            throw new XMLPullParserException(this, "expected valid name start character for value reference");
        }
        this.goBack();
        ch1 = this.iBufferChar[startPos];
        char ch2 = this.iBufferChar[startPos + 1];
        char ch3 = this.iBufferChar[startPos + 2];
        if (ch1 == 'l' && ch2 == 't' && ch3 == ';') {
            return 60;
        }
        if (ch1 == 'g' && ch2 == 't' && ch3 == ';') {
            return 62;
        }
        char ch4 = this.iBufferChar[startPos + 3];
        if (ch1 == 'a' && ch2 == 'm' && ch3 == 'p' && ch4 == ';') {
            return 38;
        }
        char ch5 = this.iBufferChar[startPos + 4];
        if (ch1 == 'a' && ch2 == 'p' && ch3 == 'o' && ch4 == 's' && ch5 == ';') {
            return 39;
        }
        if (ch1 == 'q' && ch2 == 'u' && ch3 == 'o' && ch4 == 't' && ch5 == ';') {
            return 34;
        }
        return -1;
    }

    protected int parseStartElement(char ch) throws IOException {
        this.resetAttributes();
        int startElementName = this.iCurrentPosition - 1;
        while (this.isValidElementNameChar(ch = (char)this.getNextChar())) {
        }
        int endElementName = this.iCurrentPosition;
        this.iElementName = new String(this.iBufferChar, startElementName, endElementName - startElementName - 1);
        this.iElementNames.add(this.iElementName.toUpperCase());
        while ((ch = this.skipOptionalSpaces(ch)) != '>') {
            if (ch == '/') {
                ch = (char)this.getNextChar();
                if (ch != '>') {
                    throw new XMLPullParserException(this, "'=' was expected, but '" + this.escape(ch) + "' was found instead");
                }
                this.iClosingElementNamePending = true;
                continue;
            }
            if (this.isValidStartElementNameChar(ch)) {
                this.parseAttribute(ch);
                ch = (char)this.getNextChar();
                continue;
            }
            throw new XMLPullParserException(this, "Element type \"CIM\" must be followed by either attribute specifications, \">\" or \"/>\".");
        }
        return -1;
    }

    protected void parseUnknown() throws IOException {
        char ch;
        do {
            if ((ch = (char)this.getNextChar()) != '<') continue;
            throw new XMLPullParserException("The must end with a '>' delimiter.");
        } while (ch != '>');
    }

    protected void resetAttributes() {
        this.iTotalAttributes = 0;
    }

    protected char skipOptionalSpaces(char ch) throws IOException {
        while (this.isSpace(ch)) {
            ch = (char)this.getNextChar();
        }
        return ch;
    }

    protected char skipRequiredSpaces(char ch) throws IOException {
        if (!this.isSpace(ch)) {
            throw new XMLPullParserException(this, "space spected");
        }
        while (this.isSpace(ch = (char)this.getNextChar())) {
        }
        return ch;
    }

    class XMLAttributeValue {
        int iCurrentPos;
        int iBegin;
        int iLen;
        int iHash;
        String iText;
        private boolean iTranslate;

        public XMLAttributeValue(int begin, int len, boolean translate, int hash) {
            this.iBegin = begin;
            this.iLen = len;
            this.iTranslate = translate;
            this.iHash = hash;
        }

        public XMLAttributeValue(int begin, int len, int hash) {
            this.iBegin = begin;
            this.iLen = len;
            this.iTranslate = true;
            this.iHash = hash;
        }

        public String getText() {
            if (this.iText == null) {
                if (this.iTranslate) {
                    try {
                        this.iText = this._getChars();
                    }
                    catch (Exception e) {
                        Logger logger = SessionProperties.getGlobalProperties().getLogger();
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "exception while decoding CHARACTERS XML", e);
                        }
                        this.iText = new String(XMLPullParser.this.iBufferChar, this.iBegin, this.iLen);
                    }
                } else {
                    this.iText = new String(XMLPullParser.this.iBufferChar, this.iBegin, this.iLen);
                }
                this.iHash = 0;
            }
            return this.iText;
        }

        public void init(int begin, int len) {
            this.iBegin = begin;
            this.iLen = len;
            this.iText = null;
        }

        public void setTranslate(boolean translate, int hash) {
            this.iTranslate = translate;
            this.iHash = hash;
        }

        public String toString() {
            return this.getText();
        }

        protected String _getChars() throws XMLPullParserException {
            StringBuffer attributeValue = new StringBuffer();
            int last = this.iBegin + this.iLen;
            this.iCurrentPos = this.iBegin;
            while (this.iCurrentPos < last) {
                char ch = XMLPullParser.this.iBufferChar[this.iCurrentPos];
                if (ch == '&') {
                    int ref = this.parseReference();
                    if (ref > -1) {
                        attributeValue.append((char)ref);
                    }
                } else {
                    attributeValue.append(ch);
                }
                ++this.iCurrentPos;
            }
            return attributeValue.toString();
        }

        protected int parseReference() throws XMLPullParserException {
            char ch1;
            ++this.iCurrentPos;
            if ((ch1 = XMLPullParser.this.iBufferChar[this.iCurrentPos++]) == '#') {
                if ((ch1 = XMLPullParser.this.iBufferChar[this.iCurrentPos++]) == 'x') {
                    int value = 0;
                    while (true) {
                        if ((ch1 = XMLPullParser.this.iBufferChar[this.iCurrentPos++]) >= '0' && ch1 <= '9') {
                            value = value * 16 + (ch1 - 48);
                            continue;
                        }
                        if ((ch1 < 'A' || ch1 > 'F') && (ch1 < 'a' || ch1 > 'z')) break;
                        value = value * 16 + (Character.toUpperCase(ch1) - 65 + 10);
                    }
                    if (ch1 != ';') {
                        throw new XMLPullParserException("invalid character while parsing hex encoded number " + XMLPullParser.this.escape(ch1));
                    }
                    --this.iCurrentPos;
                    return (char)value;
                }
                int value = 0;
                if (ch1 >= '0' && ch1 <= '9') {
                    while (ch1 >= '0' && ch1 <= '9') {
                        value = value * 10 + (ch1 - 48);
                        ch1 = XMLPullParser.this.iBufferChar[this.iCurrentPos++];
                    }
                    if (ch1 != ';') {
                        throw new XMLPullParserException("invalid character while parsing decinal encoded character: " + XMLPullParser.this.escape(ch1));
                    }
                    --this.iCurrentPos;
                    return (char)value;
                }
                throw new XMLPullParserException("invalid number format");
            }
            int startPos = this.iCurrentPos - 1;
            if (XMLPullParser.this.isValidStartElementNameChar(ch1)) {
                while ((ch1 = XMLPullParser.this.iBufferChar[this.iCurrentPos++]) != ';') {
                    if (XMLPullParser.this.isValidElementNameChar(ch1)) continue;
                    throw new XMLPullParserException("invalid reference character " + XMLPullParser.this.escape(ch1));
                }
            } else {
                throw new XMLPullParserException("expected valid name start character for value reference");
            }
            --this.iCurrentPos;
            ch1 = XMLPullParser.this.iBufferChar[startPos];
            char ch2 = XMLPullParser.this.iBufferChar[startPos + 1];
            char ch3 = XMLPullParser.this.iBufferChar[startPos + 2];
            if (ch1 == 'l' && ch2 == 't' && ch3 == ';') {
                return 60;
            }
            if (ch1 == 'g' && ch2 == 't' && ch3 == ';') {
                return 62;
            }
            char ch4 = XMLPullParser.this.iBufferChar[startPos + 3];
            if (ch1 == 'a' && ch2 == 'm' && ch3 == 'p' && ch4 == ';') {
                return 38;
            }
            char ch5 = XMLPullParser.this.iBufferChar[startPos + 4];
            if (ch1 == 'a' && ch2 == 'p' && ch3 == 'o' && ch4 == 's' && ch5 == ';') {
                return 39;
            }
            if (ch1 == 'q' && ch2 == 'u' && ch3 == 'o' && ch4 == 't' && ch5 == ';') {
                return 34;
            }
            return -1;
        }
    }

    class XMLAttributes
    implements Attributes {
        XMLAttributes() {
        }

        public int getIndex(String qName) {
            return XMLPullParser.this.iAttributeNames.indexOf(qName);
        }

        public int getIndex(String uri, String localName) {
            return 0;
        }

        public int getLength() {
            return XMLPullParser.this.iTotalAttributes;
        }

        public String getLocalName(int index) {
            return XMLPullParser.EMPTY;
        }

        public String getQName(int index) {
            return ((XMLAttributeValue)XMLPullParser.this.iAttributeNames.elementAt(index)).getText();
        }

        public String getType(int index) {
            return XMLPullParser.EMPTY;
        }

        public String getType(String qName) {
            return XMLPullParser.EMPTY;
        }

        public String getType(String uri, String localName) {
            return XMLPullParser.EMPTY;
        }

        public String getURI(int index) {
            return XMLPullParser.EMPTY;
        }

        public String getValue(int index) {
            return ((XMLAttributeValue)XMLPullParser.this.iAttributeValues.elementAt(index)).getText();
        }

        public String getValue(String qName) {
            return ((XMLAttributeValue)XMLPullParser.this.iAttributeValues.elementAt(XMLPullParser.this.iAttributeNames.indexOf(qName))).getText();
        }

        public String getValue(String uri, String localName) {
            return XMLPullParser.EMPTY;
        }
    }

    class FastStringHash {
        int iHash;
        String iStr;

        public FastStringHash(String str, int hash) {
            this.iStr = str;
            this.iHash = hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FastStringHash)) {
                return false;
            }
            return this.iHash == ((FastStringHash)o).iHash;
        }
    }

    class CharString {
        private int iCount;
        private int iHash;
        private int iOffset;
        private char[] iValue;

        public CharString(char[] value, int begin, int count) {
            this(value, begin, count, null);
        }

        public CharString(char[] value, int begin, int count, String str) {
            this.iValue = value;
            this.iOffset = begin;
            this.iCount = count;
            this.iHash = 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CharString)) {
                return false;
            }
            String s = (String)o;
            int pos = this.iOffset;
            for (int i = 0; i < this.iCount; ++i) {
                if (this.iValue[pos] != s.charAt(i)) {
                    return false;
                }
                ++pos;
            }
            return true;
        }

        public int hashCode() {
            int h = this.iHash;
            if (h == 0) {
                int off = this.iOffset;
                char[] val = this.iValue;
                int len = this.iCount;
                for (int i = 0; i < len; ++i) {
                    h = 31 * h + val[off++];
                }
                this.iHash = h;
            }
            return h;
        }

        public void init(char[] value, int begin, int count, String str) {
            this.iValue = value;
            this.iOffset = begin;
            this.iCount = count;
            this.iHash = 0;
        }

        public int quickHash() {
            int length = this.iValue.length;
            if (this.iHash == 0 && this.iValue != null && length > 0) {
                this.iHash = this.iValue[0] * 37 + this.iValue[length - 1] * 31 + this.iValue[length >> 1] * 7;
            }
            return this.iHash;
        }
    }
}

