/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLHostStr {
    private String iHostStr;
    private String iProtocol;
    private String iHost;
    private String iPort;
    private String iFile;
    private static final String PR_SEP = "://";
    private static final Pattern PORT_PAT = Pattern.compile("^(.+):([0-9]+)(\\/.+)?$");

    public XMLHostStr() {
    }

    public XMLHostStr(String pXMLHostStr) {
        this.set(pXMLHostStr);
    }

    public void set(String pXMLHostStr) {
        int pos;
        if (XMLHostStr.isIPv6Literal(pXMLHostStr)) {
            this.iPort = null;
            this.iProtocol = null;
            this.iHost = pXMLHostStr;
        } else {
            this.iHostStr = pXMLHostStr;
            this.iProtocol = this.parseProtocol();
            this.iPort = this.parsePort();
            this.iHost = this.iHostStr;
        }
        if (this.iPort == null && (pos = this.iHost.indexOf(47)) > 0) {
            this.iFile = this.iHost.substring(pos + 1);
            this.iHost = this.iHost.substring(0, pos);
        }
    }

    public String getProtocol() {
        return this.iProtocol;
    }

    public String getHost() {
        return this.iHost;
    }

    public String getPort() {
        return this.iPort;
    }

    public String getFile() {
        return this.iFile;
    }

    public String toString() {
        return "protocol:" + this.getProtocol() + ", host:" + this.getHost() + ", port:" + this.getPort() + ", file:" + this.getFile();
    }

    private static boolean isIPv6Literal(String pStr) {
        if (pStr == null || pStr.length() == 0) {
            return false;
        }
        int numOfDoubleColons = 0;
        int colonCnt = 0;
        int numOfNumbers = 0;
        int digitCnt = 0;
        for (int i = 0; i < pStr.length(); ++i) {
            char ch = pStr.charAt(i);
            if (Character.digit(ch, 16) >= 0) {
                if (i == 0 && colonCnt == 1 || digitCnt >= 4) {
                    return false;
                }
                ++digitCnt;
                colonCnt = 0;
                continue;
            }
            if (ch == ':') {
                if (i == pStr.length() - 1 && colonCnt == 0 || colonCnt >= 2) {
                    return false;
                }
                if (++colonCnt == 2) {
                    if (numOfDoubleColons > 0 || numOfNumbers >= 8) {
                        return false;
                    }
                    ++numOfDoubleColons;
                }
                if (digitCnt <= 0) continue;
                digitCnt = 0;
                if (numOfNumbers >= 8) {
                    return false;
                }
                ++numOfNumbers;
                continue;
            }
            return false;
        }
        if (digitCnt > 0) {
            ++numOfNumbers;
        }
        return (numOfNumbers != 8 || numOfDoubleColons <= 0) && numOfNumbers <= 8;
    }

    private String parseProtocol() {
        int pos = this.iHostStr.indexOf(PR_SEP);
        if (pos < 0) {
            return null;
        }
        String protocol = this.iHostStr.substring(0, pos);
        this.iHostStr = this.iHostStr.substring(pos + PR_SEP.length());
        return protocol;
    }

    private String parsePort() {
        Matcher m = PORT_PAT.matcher(this.iHostStr);
        if (!m.matches()) {
            return null;
        }
        this.iHostStr = m.group(1);
        this.iFile = m.group(3);
        return m.group(2);
    }
}

