/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cimxml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cimxml.CIMXmlUtil;
import org.sblim.wbem.cimxml.CimXmlSerializer;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.xml.CIMXMLBuilderImpl;
import org.sblim.wbem.xml.CIMXMLParserImpl;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CIMXmlUtilImpl
implements CIMXmlUtil {
    private DocumentBuilder iBuilder;

    public synchronized String CIMElementToXml(CIMElement pElement) throws CIMException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (this.iBuilder == null) {
                this.iBuilder = factory.newDocumentBuilder();
            }
        }
        catch (ParserConfigurationException e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        Document doc = this.iBuilder.newDocument();
        Element elem = null;
        if (pElement instanceof CIMInstance) {
            elem = CIMXMLBuilderImpl.createINSTANCE(doc, null, (CIMInstance)pElement);
        } else if (pElement instanceof CIMClass) {
            elem = CIMXMLBuilderImpl.createCLASS(doc, null, (CIMClass)pElement);
        } else if (pElement instanceof CIMMethod) {
            elem = CIMXMLBuilderImpl.createMETHOD(doc, null, (CIMMethod)pElement, null);
        } else if (pElement instanceof CIMMethod) {
            elem = CIMXMLBuilderImpl.createPARAMETER(doc, null, (CIMParameter)pElement);
        } else if (pElement instanceof CIMProperty) {
            elem = CIMXMLBuilderImpl.createPROPERTY(doc, null, (CIMProperty)pElement);
        } else if (pElement instanceof CIMQualifier) {
            elem = CIMXMLBuilderImpl.createQUALIFIER(doc, null, (CIMQualifier)pElement);
        } else if (pElement instanceof CIMQualifierType) {
            elem = CIMXMLBuilderImpl.createQUALIFIER_DECLARATION(doc, null, (CIMQualifierType)pElement);
        }
        doc.appendChild(elem);
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            CimXmlSerializer.serialize(byteOS, doc, true);
            return byteOS.toString();
        }
        catch (IOException e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public synchronized CIMElement getCIMElement(String pXmlString) throws IOException, SAXException {
        Vector o;
        int parser = SessionProperties.getGlobalProperties().getXmlParser();
        if (parser == 2) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                if (this.iBuilder == null) {
                    this.iBuilder = factory.newDocumentBuilder();
                }
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
            Document doc = this.iBuilder.parse(new InputSource(new StringReader(pXmlString)));
            Object o2 = CIMXMLParserImpl.parseObject(doc.getDocumentElement());
            if (o2 instanceof CIMElement) {
                return (CIMElement)o2;
            }
            return null;
        }
        XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl();
        if (parser == 1) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new InputSource(new StringReader(pXmlString)), (DefaultHandler)hndlr);
            }
            catch (Exception e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "exception while parsing the XML with XML parser", e);
                }
            }
        } else if (parser == 0) {
            XMLPullParser pullParser = new XMLPullParser(new StringReader(pXmlString));
            hndlr.parse(pullParser);
        }
        if ((o = hndlr.getObjects()) != null && o.size() > 0 && o.elementAt(0) instanceof CIMElement) {
            return (CIMElement)o.elementAt(0);
        }
        return null;
    }
}

