/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class CIMScope
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = -8971815288035745263L;
    public static final int SCHEMA = 0;
    public static final int CLASS = 1;
    public static final int ASSOCIATION = 2;
    public static final int INDICATION = 3;
    public static final int PROPERTY = 4;
    public static final int REFERENCE = 5;
    public static final int METHOD = 6;
    public static final int PARAMETER = 7;
    public static final int ANY = 8;
    protected static final CIMScope[] SCOPES = new CIMScope[]{new CIMScope(0), new CIMScope(1), new CIMScope(2), new CIMScope(3), new CIMScope(4), new CIMScope(5), new CIMScope(6), new CIMScope(7), new CIMScope(8)};
    private int iScope;

    public CIMScope(int pScope) {
        if (pScope < 0 || pScope > 8) {
            throw new IllegalArgumentException("scope out of range");
        }
        this.iScope = pScope;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CIMScope)) {
            return false;
        }
        return this.iScope == ((CIMScope)obj).iScope;
    }

    public int hashCode() {
        return this.iScope;
    }

    public int getScope() {
        return this.iScope;
    }

    public static CIMScope getScope(int pScopeCode) {
        if (pScopeCode < 0 || pScopeCode > 8) {
            throw new IllegalArgumentException("scope out of range");
        }
        return SCOPES[pScopeCode];
    }

    public String toMOF() {
        if (this.iScope == 0) {
            return "Schema";
        }
        if (this.iScope == 1) {
            return "Class";
        }
        if (this.iScope == 2) {
            return "Association";
        }
        if (this.iScope == 3) {
            return "Indication";
        }
        if (this.iScope == 4) {
            return "Property";
        }
        if (this.iScope == 5) {
            return "Reference";
        }
        if (this.iScope == 6) {
            return "Method";
        }
        if (this.iScope == 7) {
            return "Parameter";
        }
        if (this.iScope == 8) {
            return "Any";
        }
        return "INVALID SCOPE";
    }

    public String toString() {
        return this.toMOF();
    }

    public Object clone() {
        return this;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMScope)) {
            throw new IllegalArgumentException("Invalid object to comparte with");
        }
        return this.iScope - ((CIMScope)o).iScope;
    }
}

