/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.CharUtils;
import org.sblim.wbem.util.SessionProperties;

public class CIMObjectPath
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2827390267133787271L;
    private static final String EMPTY = "";
    private String iClassName;
    private String iHost;
    private String iNamespace;
    private Vector iKeys = new Vector();
    protected String iToString;

    public CIMObjectPath() {
        this(EMPTY, EMPTY);
    }

    public CIMObjectPath(String pClassName) {
        this(pClassName, EMPTY);
    }

    public CIMObjectPath(String pClassName, String pNamespace) throws CIMException {
        this.iClassName = pClassName;
        this.setNamespace(pNamespace);
    }

    public CIMObjectPath(String pClassName, Vector pKeyValuePairs) {
        this(pClassName, EMPTY);
        if (pKeyValuePairs == null) {
            throw new IllegalArgumentException("null keys argument");
        }
        this.setKeys(pKeyValuePairs);
    }

    protected void setNamespace(String pNamespace) {
        if (pNamespace != null) {
            if (pNamespace.indexOf(92) > -1) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", "namespace should not contain '\\' character");
            }
            boolean tryAgain = false;
            do {
                tryAgain = false;
                if (pNamespace.startsWith("/")) {
                    pNamespace = pNamespace.substring(1);
                    tryAgain = true;
                }
                if (!pNamespace.endsWith("/")) continue;
                pNamespace = pNamespace.substring(0, pNamespace.length() - 1);
                tryAgain = true;
            } while (tryAgain);
            this.iNamespace = pNamespace;
        } else {
            this.iNamespace = EMPTY;
        }
    }

    public void addKey(String pPropertyName, CIMValue pValue) {
        if (pPropertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        this.addKey(new CIMProperty(pPropertyName, pValue));
    }

    public void addKey(CIMProperty pProperty) {
        block6: {
            if (pProperty == null) {
                throw new IllegalArgumentException("null property name argument");
            }
            try {
                CIMQualifier key = new CIMQualifier("Key");
                pProperty.addQualifier(key);
            }
            catch (Exception e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "exception while adding key property", e);
            }
        }
        Iterator iter = this.iKeys.iterator();
        int i = 0;
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            String name = key.getName();
            if (name.equalsIgnoreCase(pProperty.getName())) {
                return;
            }
            if (name.compareTo(pProperty.getName()) > 0) {
                this.iKeys.insertElementAt(pProperty, i);
                this.iToString = null;
                return;
            }
            ++i;
        }
        this.iKeys.add(pProperty);
        this.iToString = null;
    }

    public void removeAllKeys() {
        this.iKeys.setSize(0);
        this.iToString = null;
    }

    public void removeKey(String pPropertyName) {
        Iterator iter = this.iKeys.iterator();
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            if (!key.getName().equalsIgnoreCase(pPropertyName)) continue;
            iter.remove();
            this.iToString = null;
            break;
        }
    }

    public Object clone() {
        CIMObjectPath that = new CIMObjectPath();
        that.iNamespace = this.iNamespace;
        that.iClassName = this.iClassName;
        that.iHost = this.iHost;
        if (this.iKeys != null) {
            Iterator iter = this.iKeys.iterator();
            while (iter.hasNext()) {
                that.iKeys.add(((CIMProperty)iter.next()).clone());
            }
        }
        return that;
    }

    public static CIMObjectPath parse(String pObjectPath) {
        throw new RuntimeException("not implemented");
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    public boolean equals(Object pObject, boolean pIgnoreClassOrigin) {
        if (!(pObject instanceof CIMObjectPath)) {
            return false;
        }
        if (pObject == this) {
            return true;
        }
        CIMObjectPath that = (CIMObjectPath)pObject;
        if (!(this.iClassName != null ? this.iClassName.equalsIgnoreCase(that.iClassName) : that.iClassName == null)) {
            return false;
        }
        if (!(this.iNamespace != null ? this.iNamespace.equalsIgnoreCase(that.iNamespace) : that.iNamespace == null)) {
            return false;
        }
        if (that.iKeys.size() != this.iKeys.size()) {
            return false;
        }
        for (int i = 0; i < that.iKeys.size(); ++i) {
            CIMProperty thatProperty = (CIMProperty)that.iKeys.elementAt(i);
            CIMProperty thisProperty = (CIMProperty)this.iKeys.elementAt(i);
            if (!thatProperty.getName().equalsIgnoreCase(thisProperty.getName())) {
                return false;
            }
            if (!pIgnoreClassOrigin && !(thisProperty.getOriginClass() != null ? thatProperty.getOriginClass().equalsIgnoreCase(thisProperty.getOriginClass()) : thatProperty.getOriginClass() == null)) {
                return false;
            }
            CIMValue thatValue = thatProperty.getValue();
            CIMValue thisValue = thisProperty.getValue();
            if (thisValue != null ? thisValue.equals(thatValue) : thisValue == null) continue;
            return false;
        }
        return true;
    }

    public String getHost() {
        return this.iHost;
    }

    public CIMProperty getKey(String pPropertyName) {
        if (pPropertyName == null) {
            return null;
        }
        Iterator iterator = this.iKeys.iterator();
        while (iterator.hasNext()) {
            CIMProperty key = (CIMProperty)iterator.next();
            if (!key.getName().equalsIgnoreCase(pPropertyName)) continue;
            return key;
        }
        return null;
    }

    public Vector getKeys() {
        return this.iKeys;
    }

    public String getNameSpace() {
        return this.iNamespace;
    }

    public void setNameSpace(CIMNameSpace pNamespace) {
        if (pNamespace == null) {
            this.iNamespace = null;
            this.iHost = null;
        } else {
            this.iHost = pNamespace.getHost();
            this.setNamespace(pNamespace.getNameSpace());
        }
        this.iToString = null;
    }

    public String getObjectName() {
        return this.iClassName;
    }

    public void setHost(String pHost) {
        this.iHost = pHost;
    }

    public void setNameSpace(String pNamespace) {
        this.setNamespace(pNamespace);
        this.iToString = null;
    }

    public void setObjectName(String pName) {
        this.iClassName = pName;
        this.iToString = null;
    }

    public void setKeys(Vector pKeys) {
        if (pKeys == null) {
            throw new IllegalArgumentException("null keys argument");
        }
        try {
            Iterator iter = pKeys.iterator();
            while (iter.hasNext()) {
                CIMProperty prop = (CIMProperty)iter.next();
                this.addKey(prop);
            }
            this.iToString = null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("key vector contains must contains CIMProperties only");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.iNamespace != null && this.iNamespace.trim().length() != 0) {
            sb.append(this.iNamespace);
            sb.append(":");
        }
        if (this.iClassName != null) {
            sb.append(this.iClassName);
        }
        if (this.iKeys != null && this.iKeys.size() > 0) {
            sb.append(".");
            boolean first = false;
            for (int i = 0; i < this.iKeys.size(); ++i) {
                CIMProperty property = (CIMProperty)this.iKeys.elementAt(i);
                if (property == null) continue;
                CIMValue value = property.getValue();
                if (first) {
                    sb.append(",");
                }
                first = true;
                String propertyName = property.getName();
                Object o = null;
                if (value != null && (o = value.getValue()) != null) {
                    if (o instanceof String) {
                        sb.append(propertyName + "=\"" + CharUtils.escape((String)o) + "\"");
                        continue;
                    }
                    if (value.getValue() instanceof CIMObjectPath) {
                        sb.append(propertyName + "=\"" + CharUtils.escape(o.toString()) + "\"");
                        continue;
                    }
                    sb.append(propertyName + "=" + o.toString());
                    continue;
                }
                sb.append(propertyName + "=null");
            }
        }
        this.iToString = sb.toString();
        return this.iToString;
    }

    public String toString(boolean pIncludeHostname) {
        StringBuffer sb = new StringBuffer();
        if (this.iHost != null) {
            if (!this.iHost.startsWith("//")) {
                sb.append("//");
            }
            sb.append(this.iHost);
            sb.append("/");
        } else {
            sb.append("///");
        }
        sb.append(this.toString());
        return sb.toString();
    }

    public int hashCode() {
        int keyHashCode = 0;
        Iterator iter = this.iKeys.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            int propHashCode = 0;
            propHashCode = prop.getName().hashCode() << 16 + (prop.getValue() != null ? prop.getValue().hashCode() : 0);
            keyHashCode = keyHashCode * 31 + propHashCode;
        }
        return (this.iClassName != null ? this.iClassName.toUpperCase().hashCode() : 0) + (this.iNamespace != null ? this.iNamespace.hashCode() : 0) + keyHashCode;
    }

    public static void main(String[] args) {
        CIMObjectPath op1 = new CIMObjectPath("CIM_ComputerSystem", "/////");
        CIMObjectPath op2 = new CIMObjectPath("CIM_ComputerSystem", (String)null);
        System.out.println("Equals:" + op1.equals(op2));
        CIMProperty p1 = new CIMProperty("Name", new CIMValue(new Integer(1), CIMDataType.getPredefinedType(5)));
        CIMProperty p2 = new CIMProperty("Name", new CIMValue(new Integer(1), CIMDataType.getPredefinedType(5)));
        p1.addQualifier(new CIMQualifier("Key"));
        p2.addQualifier(new CIMQualifier("Overridable"));
        op1.addKey(p1);
        op2.addKey(p2);
        System.out.println("op1" + op1);
        System.out.println("op2" + op2);
        long initial = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            op1.equals(op2);
            op1.hashCode();
            op2.hashCode();
        }
        System.out.println("Elapse:" + (double)(System.currentTimeMillis() - initial) / 1000000.0);
    }
}

