/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class CIMFlavor
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = 87386188021225409L;
    public static final int ENABLEOVERRIDE = 0;
    public static final int DISABLEOVERRIDE = 1;
    public static final int RESTRICTED = 2;
    public static final int TOSUBCLASS = 3;
    public static final int TRANSLATE = 4;
    private int iFlavor;
    private static final CIMFlavor[] FLAVORS = new CIMFlavor[]{new CIMFlavor(0), new CIMFlavor(1), new CIMFlavor(2), new CIMFlavor(3), new CIMFlavor(4)};

    public CIMFlavor(int pFlavor) {
        if (pFlavor < 0 || pFlavor > 4) {
            throw new IllegalArgumentException("Flavor value out of range");
        }
        this.iFlavor = pFlavor;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CIMFlavor)) {
            return false;
        }
        return this.iFlavor == ((CIMFlavor)obj).iFlavor;
    }

    public int hashCode() {
        return this.iFlavor;
    }

    public int getFlavor() {
        return this.iFlavor;
    }

    public static CIMFlavor getFlavor(int flavor) {
        if (flavor < 0 || flavor > 4) {
            throw new IllegalArgumentException("Flavor value out of range");
        }
        return FLAVORS[flavor];
    }

    public String toMOF() {
        if (this.iFlavor == 0) {
            return "EnableOverride";
        }
        if (this.iFlavor == 1) {
            return "DisableOverride";
        }
        if (this.iFlavor == 2) {
            return "Restricted";
        }
        if (this.iFlavor == 3) {
            return "ToSubclass";
        }
        if (this.iFlavor == 4) {
            return "Translatable";
        }
        return "INVALID FLAVOR";
    }

    public String toString() {
        return this.toMOF();
    }

    public Object clone() {
        return this;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMFlavor)) {
            throw new IllegalArgumentException("Invalid object to comparte with");
        }
        return this.iFlavor - ((CIMFlavor)o).iFlavor;
    }
}

