/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.Type;

public final class Utils {
    public static final String XBEAN_ANNOTATION = "org.apache.xbean.XBean";
    public static final String PROPERTY_ANNOTATION = "org.apache.xbean.Property";
    public static final Map XSD_TYPES;

    private Utils() {
    }

    public static String decapitalise(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static boolean isSimpleType(Type type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isCollection()) {
            return false;
        }
        String name = type.getName();
        if (name.equals("java.lang.Class") || name.equals("javax.xml.namespace.QName")) {
            return true;
        }
        return Utils.hasPropertyEditor(name);
    }

    private static boolean hasPropertyEditor(String type) {
        try {
            Class theClass = Utils.loadClass(type);
            PropertyEditor editor = PropertyEditorManager.findEditor(theClass);
            return editor != null;
        }
        catch (Throwable e) {
            System.out.println("Warning, could not load class: " + type + ": " + e);
            return false;
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Utils.class.getClassLoader().loadClass(name);
    }

    public static String getXsdType(Type type) {
        String name = type.getName();
        String xsdType = (String)XSD_TYPES.get(name);
        if (xsdType == null) {
            xsdType = "xs:string";
        }
        return xsdType;
    }

    public static List findImplementationsOf(NamespaceMapping namespaceMapping, Type type) {
        ArrayList<ElementMapping> elements = new ArrayList<ElementMapping>();
        String nestedTypeName = type.getName();
        for (ElementMapping element : namespaceMapping.getElements()) {
            if (!element.getClassName().equals(nestedTypeName) && !element.getInterfaces().contains(nestedTypeName) && !element.getSuperClasses().contains(nestedTypeName)) continue;
            elements.add(element);
        }
        return elements;
    }

    static {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put(String.class.getName(), "xs:string");
        map2.put(Boolean.class.getName(), "xs:boolean");
        map2.put(Boolean.TYPE.getName(), "xs:boolean");
        map2.put(Byte.class.getName(), "xs:byte");
        map2.put(Byte.TYPE.getName(), "xs:byte");
        map2.put(Short.class.getName(), "xs:short");
        map2.put(Short.TYPE.getName(), "xs:short");
        map2.put(Integer.class.getName(), "xs:integer");
        map2.put(Integer.TYPE.getName(), "xs:integer");
        map2.put(Long.class.getName(), "xs:long");
        map2.put(Long.TYPE.getName(), "xs:long");
        map2.put(Float.class.getName(), "xs:float");
        map2.put(Float.TYPE.getName(), "xs:float");
        map2.put(Double.class.getName(), "xs:double");
        map2.put(Double.TYPE.getName(), "xs:double");
        map2.put(java.util.Date.class.getName(), "xs:date");
        map2.put(Date.class.getName(), "xs:date");
        map2.put("javax.xml.namespace.QName", "xs:QName");
        XSD_TYPES = Collections.unmodifiableMap(map2);
    }
}

