/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.Serializable;
import javax.resource.spi.ConnectionRequestInfo;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.ra.MessageActivationSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQConnectionRequestInfo
implements ConnectionRequestInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5754338187296859149L;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String userName;
    private String password;
    private String serverUrl;
    private String clientid;
    private Boolean useInboundSession;
    private RedeliveryPolicy redeliveryPolicy;
    private ActiveMQPrefetchPolicy prefetchPolicy;
    private Boolean useSessionArgs;
    private String trustStore;
    private String trustStorePassword;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreKeyPassword;

    public ActiveMQConnectionRequestInfo copy() {
        try {
            ActiveMQConnectionRequestInfo answer = (ActiveMQConnectionRequestInfo)this.clone();
            if (this.redeliveryPolicy != null) {
                answer.redeliveryPolicy = this.redeliveryPolicy.copy();
            }
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public boolean isConnectionFactoryConfigured() {
        return this.serverUrl != null || this.clientid != null || this.redeliveryPolicy != null || this.prefetchPolicy != null;
    }

    public void configure(ActiveMQConnectionFactory factory, MessageActivationSpec activationSpec) {
        if (this.serverUrl != null) {
            factory.setBrokerURL(this.serverUrl);
        }
        if (this.clientid != null) {
            factory.setClientID(this.clientid);
        }
        if (this.redeliveryPolicy != null) {
            factory.setRedeliveryPolicy(this.redeliveryPolicy);
        }
        if (this.prefetchPolicy != null) {
            factory.setPrefetchPolicy(this.prefetchPolicy);
        }
        if (factory instanceof ActiveMQSslConnectionFactory) {
            String trustStore = this.defaultValue(activationSpec == null ? null : activationSpec.getTrustStore(), this.getTrustStore());
            String trustStorePassword = this.defaultValue(activationSpec == null ? null : activationSpec.getTrustStorePassword(), this.getTrustStorePassword());
            String keyStore = this.defaultValue(activationSpec == null ? null : activationSpec.getKeyStore(), this.getKeyStore());
            String keyStorePassword = this.defaultValue(activationSpec == null ? null : activationSpec.getKeyStorePassword(), this.getKeyStorePassword());
            String keyStoreKeyPassword = this.defaultValue(activationSpec == null ? null : activationSpec.getKeyStoreKeyPassword(), this.getKeyStoreKeyPassword());
            ActiveMQSslConnectionFactory sslFactory = (ActiveMQSslConnectionFactory)factory;
            if (trustStore != null) {
                try {
                    sslFactory.setTrustStore(trustStore);
                }
                catch (Exception e) {
                    this.log.warn("Unable to set TrustStore", (Throwable)e);
                }
            }
            if (trustStorePassword != null) {
                sslFactory.setTrustStorePassword(trustStorePassword);
            }
            if (keyStore != null) {
                try {
                    sslFactory.setKeyStore(keyStore);
                }
                catch (Exception e) {
                    this.log.warn("Unable to set KeyStore", (Throwable)e);
                }
            }
            if (keyStorePassword != null) {
                sslFactory.setKeyStorePassword(keyStorePassword);
            }
            if (keyStoreKeyPassword != null) {
                sslFactory.setKeyStoreKeyPassword(keyStoreKeyPassword);
            }
        }
    }

    public int hashCode() {
        int rc = 0;
        if (this.useInboundSession != null) {
            rc ^= this.useInboundSession.hashCode();
        }
        if (this.useSessionArgs != null) {
            rc ^= this.useSessionArgs.hashCode();
        }
        if (this.serverUrl != null) {
            rc ^= this.serverUrl.hashCode();
        }
        return rc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ActiveMQConnectionRequestInfo i = (ActiveMQConnectionRequestInfo)o;
        if (this.notEqual(this.serverUrl, i.serverUrl)) {
            return false;
        }
        if (this.notEqual(this.useInboundSession, i.useInboundSession)) {
            return false;
        }
        return !this.notEqual(this.useSessionArgs, i.useSessionArgs);
    }

    private boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userid) {
        this.userName = userid;
    }

    public String getClientid() {
        return this.clientid;
    }

    public void setClientid(String clientid) {
        this.clientid = clientid;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public String toString() {
        return new StringBuffer("ActiveMQConnectionRequestInfo{ userName = '").append(this.userName).append("' ").append(", serverUrl = '").append(this.serverUrl).append("' ").append(", clientid = '").append(this.clientid).append("' ").append(", useSessionArgs = '").append(this.useSessionArgs).append("' ").append(", useInboundSession = '").append(this.useInboundSession).append("'  }").toString();
    }

    public Boolean getUseInboundSession() {
        return this.useInboundSession;
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.useInboundSession = useInboundSession;
    }

    public boolean isUseInboundSessionEnabled() {
        return this.useInboundSession != null && this.useInboundSession != false;
    }

    public Double getRedeliveryBackOffMultiplier() {
        return this.redeliveryPolicy().getBackOffMultiplier();
    }

    public Long getInitialRedeliveryDelay() {
        return this.redeliveryPolicy().getInitialRedeliveryDelay();
    }

    public Long getMaximumRedeliveryDelay() {
        return this.redeliveryPolicy().getMaximumRedeliveryDelay();
    }

    public Integer getMaximumRedeliveries() {
        return this.redeliveryPolicy().getMaximumRedeliveries();
    }

    public Boolean getRedeliveryUseExponentialBackOff() {
        return this.redeliveryPolicy().isUseExponentialBackOff();
    }

    public void setRedeliveryBackOffMultiplier(Double value) {
        if (value != null) {
            this.redeliveryPolicy().setBackOffMultiplier(value);
        }
    }

    public void setInitialRedeliveryDelay(Long value) {
        if (value != null) {
            this.redeliveryPolicy().setInitialRedeliveryDelay(value);
        }
    }

    public void setMaximumRedeliveryDelay(Long value) {
        if (value != null) {
            this.redeliveryPolicy().setMaximumRedeliveryDelay(value);
        }
    }

    public void setMaximumRedeliveries(Integer value) {
        if (value != null) {
            this.redeliveryPolicy().setMaximumRedeliveries(value);
        }
    }

    public void setRedeliveryUseExponentialBackOff(Boolean value) {
        if (value != null) {
            this.redeliveryPolicy().setUseExponentialBackOff(value);
        }
    }

    public Integer getDurableTopicPrefetch() {
        return this.prefetchPolicy().getDurableTopicPrefetch();
    }

    public Integer getOptimizeDurableTopicPrefetch() {
        return this.prefetchPolicy().getOptimizeDurableTopicPrefetch();
    }

    @Deprecated
    public Integer getInputStreamPrefetch() {
        return 0;
    }

    public Integer getQueueBrowserPrefetch() {
        return this.prefetchPolicy().getQueueBrowserPrefetch();
    }

    public Integer getQueuePrefetch() {
        return this.prefetchPolicy().getQueuePrefetch();
    }

    public Integer getTopicPrefetch() {
        return this.prefetchPolicy().getTopicPrefetch();
    }

    public void setAllPrefetchValues(Integer i) {
        if (i != null) {
            this.prefetchPolicy().setAll(i);
        }
    }

    public void setDurableTopicPrefetch(Integer durableTopicPrefetch) {
        if (durableTopicPrefetch != null) {
            this.prefetchPolicy().setDurableTopicPrefetch(durableTopicPrefetch);
        }
    }

    public void setOptimizeDurableTopicPrefetch(Integer optimizeDurableTopicPrefetch) {
        if (optimizeDurableTopicPrefetch != null) {
            this.prefetchPolicy().setOptimizeDurableTopicPrefetch(optimizeDurableTopicPrefetch);
        }
    }

    public void setQueueBrowserPrefetch(Integer queueBrowserPrefetch) {
        if (queueBrowserPrefetch != null) {
            this.prefetchPolicy().setQueueBrowserPrefetch(queueBrowserPrefetch);
        }
    }

    public void setQueuePrefetch(Integer queuePrefetch) {
        if (queuePrefetch != null) {
            this.prefetchPolicy().setQueuePrefetch(queuePrefetch);
        }
    }

    public void setTopicPrefetch(Integer topicPrefetch) {
        if (topicPrefetch != null) {
            this.prefetchPolicy().setTopicPrefetch(topicPrefetch);
        }
    }

    public RedeliveryPolicy redeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new RedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public ActiveMQPrefetchPolicy prefetchPolicy() {
        if (this.prefetchPolicy == null) {
            this.prefetchPolicy = new ActiveMQPrefetchPolicy();
        }
        return this.prefetchPolicy;
    }

    public boolean isUseSessionArgs() {
        return this.useSessionArgs != null ? this.useSessionArgs : false;
    }

    public Boolean getUseSessionArgs() {
        return this.useSessionArgs;
    }

    public void setUseSessionArgs(Boolean useSessionArgs) {
        this.useSessionArgs = useSessionArgs;
    }

    protected String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

