/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.util.ProducerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerCommand.class);
    String brokerUrl = ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    String user = ActiveMQConnectionFactory.DEFAULT_USER;
    String password = ActiveMQConnectionFactory.DEFAULT_PASSWORD;
    String destination = "queue://TEST";
    int messageCount = 1000;
    int sleep = 0;
    boolean persistent = true;
    String message = null;
    String payloadUrl = null;
    int messageSize = 0;
    int textMessageSize;
    long msgTTL = 0L;
    String msgGroupID = null;
    int transactionBatchSize;
    private int parallelThreads = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTask(List<String> tokens) throws Exception {
        LOG.info("Connecting to URL: " + this.brokerUrl + " as user: " + this.user);
        LOG.info("Producing messages to " + this.destination);
        LOG.info("Using " + (this.persistent ? "persistent" : "non-persistent") + " messages");
        LOG.info("Sleeping between sends " + this.sleep + " ms");
        LOG.info("Running " + this.parallelThreads + " parallel threads");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUrl);
        try (Connection conn = null;){
            conn = factory.createConnection(this.user, this.password);
            conn.start();
            CountDownLatch active = new CountDownLatch(this.parallelThreads);
            for (int i = 1; i <= this.parallelThreads; ++i) {
                Session sess = this.transactionBatchSize != 0 ? conn.createSession(true, 0) : conn.createSession(false, 1);
                ProducerThread producer = new ProducerThread(sess, ActiveMQDestination.createDestination(this.destination, (byte)1));
                producer.setName("producer-" + i);
                producer.setMessageCount(this.messageCount);
                producer.setSleep(this.sleep);
                producer.setMsgTTL(this.msgTTL);
                producer.setPersistent(this.persistent);
                producer.setTransactionBatchSize(this.transactionBatchSize);
                producer.setMessage(this.message);
                producer.setPayloadUrl(this.payloadUrl);
                producer.setMessageSize(this.messageSize);
                producer.setMsgGroupID(this.msgGroupID);
                producer.setTextMessageSize(this.textMessageSize);
                producer.setFinished(active);
                producer.start();
            }
            active.await();
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public int getTextMessageSize() {
        return this.textMessageSize;
    }

    public void setTextMessageSize(int textMessageSize) {
        this.textMessageSize = textMessageSize;
    }

    public long getMsgTTL() {
        return this.msgTTL;
    }

    public void setMsgTTL(long msgTTL) {
        this.msgTTL = msgTTL;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public void setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getParallelThreads() {
        return this.parallelThreads;
    }

    public void setParallelThreads(int parallelThreads) {
        this.parallelThreads = parallelThreads;
    }

    public String getPayloadUrl() {
        return this.payloadUrl;
    }

    public void setPayloadUrl(String payloadUrl) {
        this.payloadUrl = payloadUrl;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    protected void printHelp() {
        this.printHelpFromFile();
    }

    @Override
    public String getName() {
        return "producer";
    }

    @Override
    public String getOneLineDescription() {
        return "Sends messages to the broker";
    }
}

