/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.common.ipc;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.common.ipc.TelemetryProtos;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.springframework.beans.factory.annotation.Autowired;

public class TelemetrySinkModule
implements SinkModule<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> {
    private static final String MODULE_ID_PREFIX = "Telemetry-";
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_BATCH_INTERVAL_MS = 500;
    private static final int DEFAULT_QUEUE_SIZE = 10000;
    @Autowired
    private DistPollerDao distPollerDao;
    private final QueueDefinition queueConfig;
    private final String moduleId;

    public TelemetrySinkModule(QueueDefinition queueConfig) {
        this.queueConfig = Objects.requireNonNull(queueConfig);
        this.moduleId = MODULE_ID_PREFIX + this.queueConfig.getName();
    }

    public String getId() {
        return this.moduleId;
    }

    public int getNumConsumerThreads() {
        return this.queueConfig.getNumThreads().orElse(DEFAULT_NUM_THREADS);
    }

    public byte[] marshal(TelemetryProtos.TelemetryMessageLog message) {
        return message.toByteArray();
    }

    public TelemetryProtos.TelemetryMessageLog unmarshal(byte[] bytes) {
        try {
            return TelemetryProtos.TelemetryMessageLog.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] marshalSingleMessage(TelemetryMessage message) {
        return this.marshal(((TelemetryProtos.TelemetryMessageLog.Builder)this.getAggregationPolicy().aggregate(null, (Object)message)).build());
    }

    public TelemetryMessage unmarshalSingleMessage(byte[] message) {
        TelemetryProtos.TelemetryMessageLog messageLog = this.unmarshal(message);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(messageLog.getSourceAddress(), messageLog.getSourcePort());
        return new TelemetryMessage(inetSocketAddress, ByteBuffer.wrap(messageLog.getMessage(0).getByteArray()), new Date(messageLog.getMessage(0).getTimestamp()));
    }

    public AggregationPolicy<TelemetryMessage, TelemetryProtos.TelemetryMessageLog, TelemetryProtos.TelemetryMessageLog.Builder> getAggregationPolicy() {
        final String systemId = this.distPollerDao.whoami().getId();
        final String systemLocation = this.distPollerDao.whoami().getLocation();
        return new AggregationPolicy<TelemetryMessage, TelemetryProtos.TelemetryMessageLog, TelemetryProtos.TelemetryMessageLog.Builder>(){

            public int getCompletionSize() {
                return TelemetrySinkModule.this.queueConfig.getBatchSize().orElse(1000);
            }

            public int getCompletionIntervalMs() {
                return TelemetrySinkModule.this.queueConfig.getBatchIntervalMs().orElse(500);
            }

            public Object key(TelemetryMessage telemetryMessage) {
                return telemetryMessage.getSource();
            }

            public TelemetryProtos.TelemetryMessageLog.Builder aggregate(TelemetryProtos.TelemetryMessageLog.Builder accumulator, TelemetryMessage message) {
                if (accumulator == null) {
                    accumulator = TelemetryProtos.TelemetryMessageLog.newBuilder().setLocation(systemLocation).setSystemId(systemId).setSourceAddress(message.getSource().getHostString()).setSourcePort(message.getSource().getPort());
                }
                TelemetryProtos.TelemetryMessage messageDto = TelemetryProtos.TelemetryMessage.newBuilder().setTimestamp(message.getReceivedAt().getTime()).setBytes(ByteString.copyFrom((ByteBuffer)message.getBuffer())).build();
                accumulator.addMessage(messageDto);
                return accumulator;
            }

            public TelemetryProtos.TelemetryMessageLog build(TelemetryProtos.TelemetryMessageLog.Builder accumulator) {
                return accumulator.build();
            }
        };
    }

    public AsyncPolicy getAsyncPolicy() {
        return new AsyncPolicy(){

            public int getQueueSize() {
                return TelemetrySinkModule.this.queueConfig.getQueueSize().orElse(10000);
            }

            public int getNumThreads() {
                return TelemetrySinkModule.this.queueConfig.getNumThreads().orElse(DEFAULT_NUM_THREADS);
            }

            public boolean isBlockWhenFull() {
                return true;
            }
        };
    }

    public Optional<String> getRoutingKey(TelemetryProtos.TelemetryMessageLog message) {
        if (this.queueConfig.getUseRoutingKey().orElse(true).booleanValue()) {
            return Optional.of(String.format("%s@%s:%d", message.getLocation(), message.getSourceAddress(), message.getSourcePort()));
        }
        return Optional.empty();
    }

    public DistPollerDao getDistPollerDao() {
        return this.distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }
}

