/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.util.Map;
import java.util.concurrent.Callable;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.ticketd.TroubleTicketer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiBasedTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiBasedTicketerPlugin.class);
    private Plugin m_ticketerPlugin = null;

    public Ticket get(String ticketId) throws PluginException {
        return this.getTicketerPlugin().get(ticketId);
    }

    public void saveOrUpdate(Ticket ticket) throws PluginException {
        this.getTicketerPlugin().saveOrUpdate(ticket);
    }

    public void registerTicketerPlugin(final Plugin plugin, final Map<String, String> attributes) {
        Logging.withPrefix((String)TroubleTicketer.getLoggingCategory(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (OSGiBasedTicketerPlugin.this.m_ticketerPlugin == null) {
                    LOG.info("Registering ticketer plugin {} with attributes {}", (Object)plugin, (Object)attributes);
                    OSGiBasedTicketerPlugin.this.m_ticketerPlugin = plugin;
                } else {
                    LOG.warn("Ticketer plugin {} will not be registered, since {} is already active.", (Object)plugin, (Object)OSGiBasedTicketerPlugin.this.m_ticketerPlugin);
                }
            }
        });
    }

    public boolean unregisterTicketerPlugin(final Plugin plugin, final Map<String, String> attributes) throws Exception {
        return (Boolean)Logging.withPrefix((String)TroubleTicketer.getLoggingCategory(), (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (OSGiBasedTicketerPlugin.this.m_ticketerPlugin == plugin) {
                    LOG.info("Unregistering ticketer plugin {} with attributes {}", (Object)plugin, (Object)attributes);
                    OSGiBasedTicketerPlugin.this.m_ticketerPlugin = null;
                    return true;
                }
                return false;
            }
        });
    }

    public Plugin getTicketerPlugin() throws PluginException {
        if (this.m_ticketerPlugin == null) {
            throw new PluginException("No ticketing plugin is currently registered.");
        }
        return this.m_ticketerPlugin;
    }
}

