/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContainerInitializer;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.webapp.WebAppContext;
import org.opennms.netmgt.jetty.ApproveAbsolutePathAliases;

@ManagedObject(value="Provider for start-up deployement of webapps based on presence in directory")
public class OpenNMSWebAppProvider
extends WebAppProvider {
    public ContextHandler createContextHandler(App app) throws Exception {
        ContextHandler handler = super.createContextHandler(app);
        handler.addAliasCheck((ContextHandler.AliasCheck)new ApproveAbsolutePathAliases());
        if (handler instanceof WebAppContext) {
            WebAppContext context = (WebAppContext)handler;
            context.setAttribute("org.eclipse.jetty.containerInitializers", OpenNMSWebAppProvider.jspInitializers());
            context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
            context.addBean((Object)new ServletContainerInitializersStarter(context), true);
            context.setThrowUnavailableOnStartupException(true);
        }
        return handler;
    }

    private static List<ContainerInitializer> jspInitializers() {
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ContainerInitializer initializer = new ContainerInitializer((ServletContainerInitializer)sci, null);
        initializers.add(initializer);
        return initializers;
    }
}

