/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.common.distributed;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.v1.distributed.KeyValueStore;

public class KeyValueStoreWrapper<T>
implements KeyValueStore<T> {
    private static final String OIA_PREFIX = "_OIA_";
    private final org.opennms.features.distributed.kvstore.api.KeyValueStore store;

    public KeyValueStoreWrapper(org.opennms.features.distributed.kvstore.api.KeyValueStore store) {
        this.store = store;
    }

    public long put(String key, T value, String context) {
        return this.store.put(key, value, OIA_PREFIX + context);
    }

    public long put(String key, T value, String context, Integer ttlInSeconds) {
        return this.store.put(key, value, OIA_PREFIX + context, ttlInSeconds);
    }

    public Optional<T> get(String key, String context) {
        return this.store.get(key, OIA_PREFIX + context);
    }

    public Optional<T> getIfStale(String key, String context, long timestamp) {
        return this.store.getIfStale(key, OIA_PREFIX + context, timestamp);
    }

    public OptionalLong getLastUpdated(String key, String context) {
        return this.store.getLastUpdated(key, OIA_PREFIX + context);
    }

    public Map<String, T> enumerateContext(String context) {
        return this.store.enumerateContext(OIA_PREFIX + context);
    }

    public void delete(String key, String context) {
        this.store.delete(key, OIA_PREFIX + context);
    }

    public void truncateContext(String context) {
        this.store.truncateContext(OIA_PREFIX + context);
    }

    public CompletableFuture<Long> putAsync(String key, T value, String context) {
        return this.store.putAsync(key, value, OIA_PREFIX + context);
    }

    public CompletableFuture<Long> putAsync(String key, T value, String context, Integer ttlInSeconds) {
        return this.store.putAsync(key, value, OIA_PREFIX + context, ttlInSeconds);
    }

    public CompletableFuture<Optional<T>> getAsync(String key, String context) {
        return this.store.getAsync(key, OIA_PREFIX + context);
    }

    public CompletableFuture<Optional<T>> getIfStaleAsync(String key, String context, long timestamp) {
        return this.store.getIfStaleAsync(key, OIA_PREFIX + context, timestamp);
    }

    public CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        return this.store.getLastUpdatedAsync(key, OIA_PREFIX + context);
    }

    public String getName() {
        return this.store.getName();
    }

    public CompletableFuture<Map<String, T>> enumerateContextAsync(String context) {
        return this.store.enumerateContextAsync(OIA_PREFIX + context);
    }

    public CompletableFuture<Void> deleteAsync(String key, String context) {
        return this.store.deleteAsync(key, OIA_PREFIX + context);
    }

    public CompletableFuture<Void> truncateContextAsync(String context) {
        return this.store.truncateContextAsync(OIA_PREFIX + context);
    }
}

