/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.opennms.netmgt.enlinkd.NodeDiscoveryBridge;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.common.SchedulableNodeCollectorGroup;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.scheduler.LegacyPriorityExecutor;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;

public class NodeCollectionGroupBridge
extends SchedulableNodeCollectorGroup {
    private final BridgeTopologyService m_bridgeTopologyService;
    private final int m_maxBft;
    private final boolean m_disableBridgeVlanDiscovery;

    public NodeCollectionGroupBridge(long interval, long initial, LegacyPriorityExecutor executor, int priority, NodeTopologyService nodeTopologyService, LocationAwareSnmpClient locationAwareSnmpClient, BridgeTopologyService bridgeTopologyService, int max_bft, boolean disableBridgeVlanDiscovery) {
        super(interval, initial, executor, priority, ProtocolSupported.BRIDGE, nodeTopologyService, locationAwareSnmpClient);
        this.m_bridgeTopologyService = bridgeTopologyService;
        this.m_maxBft = max_bft;
        this.m_disableBridgeVlanDiscovery = disableBridgeVlanDiscovery;
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }

    public int getMaxBft() {
        return this.m_maxBft;
    }

    public boolean isDisableBridgeVlanDiscovery() {
        return this.m_disableBridgeVlanDiscovery;
    }

    public NodeCollector getNodeCollector(Node node, int priority) {
        return new NodeDiscoveryBridge(this, node, priority);
    }
}

