/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.ServiceSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMonitoredServiceDao
extends AbstractMockDao<OnmsMonitoredService, Integer>
implements MonitoredServiceDao {
    private static final Logger LOG = LoggerFactory.getLogger(MockMonitoredServiceDao.class);
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    public Integer save(OnmsMonitoredService svc) {
        this.updateParent(svc);
        Integer retval = (Integer)super.save(svc);
        this.updateSubObjects(svc);
        return retval;
    }

    @Override
    public void update(OnmsMonitoredService svc) {
        this.updateParent(svc);
        super.update(svc);
        this.updateSubObjects(svc);
    }

    private void updateParent(OnmsMonitoredService svc) {
        if (svc.getIpInterface() != null && svc.getIpInterface().getId() != null) {
            OnmsIpInterface iface = (OnmsIpInterface)this.getIpInterfaceDao().get((Serializable)svc.getIpInterface().getId());
            if (iface != null && iface != svc.getIpInterface()) {
                LOG.debug("merging interface {} into interface {}", (Object)svc.getIpInterface(), (Object)iface);
                iface.mergeInterface(svc.getIpInterface(), (EventForwarder)new AbstractMockDao.NullEventForwarder(), false);
                svc.setIpInterface(iface);
            }
            if (!svc.getIpInterface().getMonitoredServices().contains(svc)) {
                svc.getIpInterface().addMonitoredService(svc);
            }
        }
    }

    private void updateSubObjects(OnmsMonitoredService svc) {
        OnmsServiceType serviceType = svc.getServiceType();
        OnmsServiceType existingServiceType = this.getServiceTypeDao().findByName(serviceType.getName());
        if (existingServiceType != null && existingServiceType.getId() != serviceType.getId()) {
            svc.setServiceType(existingServiceType);
        }
        this.getServiceTypeDao().saveOrUpdate((Object)svc.getServiceType());
    }

    @Override
    public void flush() {
        super.flush();
        for (OnmsMonitoredService svc : this.findAll()) {
            this.updateSubObjects(svc);
        }
    }

    @Override
    protected void generateId(OnmsMonitoredService svc) {
        svc.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsMonitoredService service) {
        return service.getId();
    }

    public OnmsMonitoredService get(Integer nodeId, InetAddress ipAddress, Integer serviceId) {
        for (OnmsMonitoredService svc : this.findAll()) {
            if (svc.getNodeId() != nodeId || !svc.getIpAddress().equals(ipAddress) || serviceId != svc.getId()) continue;
            return svc;
        }
        return null;
    }

    public OnmsMonitoredService get(Integer nodeId, InetAddress ipAddr, Integer ifIndex, Integer serviceId) {
        for (OnmsMonitoredService svc : this.findAll()) {
            if (svc.getNodeId() != nodeId || !svc.getIpAddress().equals(ipAddr) || ifIndex != svc.getIfIndex() || serviceId != svc.getId()) continue;
            return svc;
        }
        return null;
    }

    public OnmsMonitoredService get(Integer nodeId, InetAddress ipAddress, String svcName) {
        for (OnmsMonitoredService svc : this.findAll()) {
            if (!nodeId.equals(svc.getNodeId()) || !ipAddress.equals(svc.getIpAddress()) || !svcName.equals(svc.getServiceName())) continue;
            return svc;
        }
        return null;
    }

    public List<OnmsMonitoredService> findByType(String typeName) {
        ArrayList<OnmsMonitoredService> services = new ArrayList<OnmsMonitoredService>();
        for (OnmsMonitoredService svc : this.findAll()) {
            if (!typeName.equals(svc.getServiceType().getName())) continue;
            services.add(svc);
        }
        return services;
    }

    public List<OnmsMonitoredService> findMatchingServices(ServiceSelector serviceSelector) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsMonitoredService> findAllServices() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Set<OnmsMonitoredService> findByApplication(OnmsApplication application) {
        HashSet<OnmsMonitoredService> services = new HashSet<OnmsMonitoredService>();
        for (OnmsMonitoredService svc : this.findAll()) {
            if (!svc.getApplications().contains(application)) continue;
            services.add(svc);
        }
        return services;
    }

    public OnmsMonitoredService getPrimaryService(Integer nodeId, String svcName) {
        for (OnmsMonitoredService svc : this.findAll()) {
            if (svc.getNodeId() != nodeId || !svcName.equals(svc.getServiceName()) || !svc.getIpInterface().isPrimary()) continue;
            return svc;
        }
        return null;
    }

    public List<OnmsMonitoredService> findByNode(int nodeId) {
        return this.findAll().stream().filter(svc -> svc.getNodeId() == nodeId).collect(Collectors.toList());
    }
}

