/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.alarmd.api.Preservable;
import org.opennms.netmgt.alarmd.api.support.StatusFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AlarmQueue<T extends Preservable> {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmQueue.class);
    private final State FORWARDING = new State(){

        @Override
        public List<T> getAlarmsToForward() throws InterruptedException {
            ArrayList<Preservable> alarms = new ArrayList<Preservable>(AlarmQueue.this.m_maxBatchSize);
            Preservable a = (Preservable)AlarmQueue.this.m_queue.take();
            alarms.add(a);
            AlarmQueue.this.m_queue.drainTo(alarms, AlarmQueue.this.m_maxBatchSize - alarms.size());
            if (AlarmQueue.this.m_naglesDelay <= 0L) {
                return alarms;
            }
            long now = System.currentTimeMillis();
            long expirationTime = now + AlarmQueue.this.m_naglesDelay;
            while (alarms.size() < AlarmQueue.this.m_maxBatchSize && now < expirationTime) {
                Preservable alarm = (Preservable)AlarmQueue.this.m_queue.poll(expirationTime - now, TimeUnit.MILLISECONDS);
                if (alarm != null) {
                    alarms.add(alarm);
                    AlarmQueue.this.m_queue.drainTo(alarms, AlarmQueue.this.m_maxBatchSize - alarms.size());
                }
                now = System.currentTimeMillis();
            }
            return alarms;
        }

        @Override
        public void forwardSuccessful(List<T> alarms) {
        }

        @Override
        public void forwardFailed(List<T> alarms) {
            this.addPreservedToPreservedQueue(alarms);
            if (!AlarmQueue.this.m_preservedQueue.isEmpty()) {
                AlarmQueue.this.setState(AlarmQueue.this.FAILING);
            }
        }

        public String toString() {
            return "FORWARDING";
        }
    };
    private final State FAILING = new State(){

        @Override
        public List<T> getAlarmsToForward() {
            this.discardNonPreservedAlarms();
            this.loadNextBatch();
            return AlarmQueue.this.m_nextBatch;
        }

        @Override
        public void forwardFailed(List<T> alarms) {
        }

        @Override
        public void forwardSuccessful(List<T> alarms) {
            AlarmQueue.this.m_nextBatch.clear();
            if (AlarmQueue.this.m_preservedQueue.isEmpty()) {
                AlarmQueue.this.setState(AlarmQueue.this.FORWARDING);
            } else {
                AlarmQueue.this.setState(AlarmQueue.this.RECOVERING);
            }
        }

        public String toString() {
            return "FAILING";
        }
    };
    private final State RECOVERING = new State(){

        @Override
        public List<T> getAlarmsToForward() {
            this.loadNextBatch();
            return AlarmQueue.this.m_nextBatch;
        }

        @Override
        public void forwardFailed(List<T> alarms) {
            AlarmQueue.this.setState(AlarmQueue.this.FAILING);
        }

        @Override
        public void forwardSuccessful(List<T> alarms) {
            AlarmQueue.this.m_nextBatch.clear();
            if (AlarmQueue.this.m_preservedQueue.isEmpty()) {
                AlarmQueue.this.setState(AlarmQueue.this.FORWARDING);
            }
        }

        public String toString() {
            return "RECOVERING";
        }
    };
    private int m_maxPreservedAlarms = 300000;
    private int m_maxBatchSize = 100;
    private long m_naglesDelay = 1000L;
    private BlockingQueue<T> m_queue = new LinkedBlockingQueue<T>();
    private BlockingQueue<T> m_preservedQueue = new LinkedBlockingQueue<T>();
    private List<T> m_nextBatch;
    private State m_state = this.FORWARDING;
    private StatusFactory<T> m_statusFactory;

    public AlarmQueue(StatusFactory<T> statusFactory) {
        this.m_statusFactory = statusFactory;
    }

    private void setState(State state) {
        this.m_state = state;
        LOG.debug("Setting state of AlarmQueue to {}", (Object)this.m_state);
    }

    public long getNaglesDelay() {
        return this.m_naglesDelay;
    }

    public void setNaglesDelay(long delay) {
        this.m_naglesDelay = delay;
    }

    public int getMaxPreservedAlarms() {
        return this.m_maxPreservedAlarms;
    }

    public void setMaxPreservedAlarms(int maxPreservedAlarms) {
        this.m_maxPreservedAlarms = maxPreservedAlarms;
    }

    public int getMaxBatchSize() {
        return this.m_maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.m_maxBatchSize = maxBatchSize;
    }

    public void init() {
        this.m_nextBatch = new ArrayList<T>(this.m_maxBatchSize);
    }

    public void discard(T a) {
    }

    public void accept(T a) {
        boolean result = this.m_queue.offer(a);
        LOG.debug("Alarm {} accepted, offered to blocking-queue. Actually queued? {}", a, (Object)result);
    }

    public void preserve(T a) {
        a.setPreserved(true);
        boolean result = this.m_queue.offer(a);
        LOG.debug("Alarm {} preserved, offered to blocking-queue. Actually queued? {}", a, (Object)result);
    }

    public List<T> getAlarmsToForward() throws InterruptedException {
        return this.m_state.getAlarmsToForward();
    }

    public void forwardSuccessful(List<T> alarms) {
        this.m_state.forwardSuccessful(alarms);
    }

    public void forwardFailed(List<T> alarms) {
        this.m_state.forwardFailed(alarms);
    }

    public abstract class State {
        abstract List<T> getAlarmsToForward() throws InterruptedException;

        abstract void forwardSuccessful(List<T> var1);

        abstract void forwardFailed(List<T> var1);

        protected void addToPreservedQueue(T a) {
            if (AlarmQueue.this.m_preservedQueue.size() >= AlarmQueue.this.m_maxPreservedAlarms) {
                AlarmQueue.this.m_nextBatch.clear();
                AlarmQueue.this.m_preservedQueue.clear();
                AlarmQueue.this.m_preservedQueue.offer(AlarmQueue.this.m_statusFactory.createSyncLostMessage());
            }
            AlarmQueue.this.m_preservedQueue.offer(a);
        }

        protected void discardNonPreservedAlarms() {
            ArrayList alarms = new ArrayList(AlarmQueue.this.m_queue.size());
            AlarmQueue.this.m_queue.drainTo(alarms);
            this.addPreservedToPreservedQueue(alarms);
        }

        protected void addPreservedToPreservedQueue(List<T> alarms) {
            for (Preservable a : alarms) {
                if (!a.isPreserved()) continue;
                this.addToPreservedQueue(a);
            }
        }

        protected void loadNextBatch() {
            AlarmQueue.this.m_preservedQueue.drainTo(AlarmQueue.this.m_nextBatch, AlarmQueue.this.m_maxBatchSize - AlarmQueue.this.m_nextBatch.size());
        }
    }
}

