/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hawt.log.support.Objects;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogEvent
implements Comparable<LogEvent>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static String defaultContainerName;
    private String host;
    private Long seq;
    private Date timestamp;
    private String level;
    private String logger;
    private String thread;
    private String message;
    private String[] exception;
    private Map<String, String> properties;
    private String className;
    private String fileName;
    private String methodName;
    private String containerName = LogEvent.getDefaultContainerName();
    private String lineNumber;

    public static LogEvent toLogEvent(Object element) {
        if (element instanceof LogEvent) {
            return (LogEvent)element;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEvent logEvent = (LogEvent)o;
        if (this.host != null ? !this.host.equals(logEvent.host) : logEvent.host != null) {
            return false;
        }
        if (this.containerName != null ? !this.containerName.equals(logEvent.containerName) : logEvent.containerName != null) {
            return false;
        }
        if (this.logger != null ? !this.logger.equals(logEvent.logger) : logEvent.logger != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(logEvent.message) : logEvent.message != null) {
            return false;
        }
        if (this.seq != null ? !this.seq.equals(logEvent.seq) : logEvent.seq != null) {
            return false;
        }
        if (this.thread != null ? !this.thread.equals(logEvent.thread) : logEvent.thread != null) {
            return false;
        }
        return !(this.timestamp != null ? !this.timestamp.equals(logEvent.timestamp) : logEvent.timestamp != null);
    }

    @Override
    public int compareTo(LogEvent that) {
        int answer = Objects.compare(this.timestamp, that.timestamp);
        if (answer == 0 && (answer = Objects.compare(this.seq, that.seq)) == 0 && (answer = Objects.compare(this.host, that.host)) == 0 && (answer = Objects.compare(this.containerName, that.containerName)) == 0 && (answer = Objects.compare(this.thread, that.thread)) == 0 && (answer = Objects.compare(this.logger, that.logger)) == 0) {
            answer = Objects.compare(this.message, that.message);
        }
        return answer;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
        result = 31 * result + (this.seq != null ? this.seq.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.logger != null ? this.logger.hashCode() : 0);
        result = 31 * result + (this.thread != null ? this.thread.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[" + this.getLevel() + "] " + this.getMessage();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public Long getSeq() {
        return this.seq;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String[] getException() {
        return this.exception;
    }

    public void setException(String[] exception) {
        this.exception = exception;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public static String getDefaultContainerName() {
        return defaultContainerName;
    }

    public static void setDefaultContainerName(String defaultContainerName) {
        LogEvent.defaultContainerName = defaultContainerName;
    }

    static {
        LogEvent.setDefaultContainerName(System.getProperty("runtime.id"));
    }
}

