/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.httplite.servlet.ServletOutputStreamImpl;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private static final int COPY_BUFFER_SIZE = 4096;
    private final SimpleDateFormat m_dateFormat;
    private final OutputStream m_out;
    private int m_bufferSize = 4096;
    private ByteArrayOutputStream m_buffer;
    private final Map m_headers = new HashMap();
    private String m_characterEncoding = "UTF-8";
    private Locale m_locale = new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
    private boolean m_getOutputStreamCalled = false;
    private boolean m_getWriterCalled = false;
    private ServletOutputStreamImpl m_servletOutputStream;
    private PrintWriter m_printWriter;
    private List m_cookies = null;
    private int m_statusCode = 200;
    private String m_customStatusMessage = null;
    private boolean m_headersWritten = false;

    public HttpServletResponseImpl(OutputStream outputStream) {
        this.m_out = outputStream;
        this.m_dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        this.m_dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    void writeHeaders(boolean close) throws IOException {
        if (this.m_headersWritten) {
            throw new IllegalStateException("Headers have already been written.");
        }
        if (!this.m_headers.containsKey("Content-Length") && this.m_buffer != null) {
            this.setContentLength(this.m_buffer.size());
        }
        this.m_out.write(HttpServletResponseImpl.buildResponse(this.m_statusCode, this.m_headers, this.m_customStatusMessage, null));
        if (this.m_cookies != null) {
            this.m_out.write("Set-Cookie: ".getBytes());
            Iterator i = this.m_cookies.iterator();
            while (i.hasNext()) {
                Cookie cookie = (Cookie)i.next();
                this.m_out.write(this.cookieToHeader(cookie));
                if (!i.hasNext()) continue;
                this.m_out.write(59);
            }
        }
        this.m_out.write("\r\n".getBytes());
        this.m_out.flush();
        if (close) {
            this.m_headersWritten = true;
        } else {
            this.m_headers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToOutputStream(InputStream inputStream, boolean close) throws IOException {
        InputStream bufferedInput = new BufferedInputStream(inputStream);
        if (!this.m_headers.containsKey("Content-Length")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HttpServletResponseImpl.copy(bufferedInput, baos);
            byte[] outputBuffer = baos.toByteArray();
            this.setContentLength(outputBuffer.length);
            bufferedInput = new ByteArrayInputStream(outputBuffer);
        }
        if (!this.m_headersWritten) {
            this.writeHeaders(close);
        }
        try {
            HttpServletResponseImpl.copy(bufferedInput, this.m_out);
            this.m_out.flush();
        }
        finally {
            if (bufferedInput != null) {
                ((InputStream)bufferedInput).close();
            }
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int len = input.read(buf);
        while (len >= 0) {
            output.write(buf, 0, len);
            len = input.read(buf);
        }
    }

    public void sendContinueResponse() throws IOException {
        this.m_out.write(HttpServletResponseImpl.buildResponse(100));
        this.m_out.flush();
    }

    public void sendMissingHostResponse() throws IOException {
        this.m_out.write(HttpServletResponseImpl.buildResponse(400));
        this.m_out.flush();
    }

    public void sendNotImplementedResponse() throws IOException {
        this.m_out.write(HttpServletResponseImpl.buildResponse(501));
        this.m_out.flush();
    }

    public void sendMovedPermanently(String hostname, int port, String newURI) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("Location");
        sb.append(": ");
        sb.append("http");
        sb.append("://");
        sb.append(hostname);
        if (port != 80) {
            sb.append(':');
            sb.append(Integer.toString(port));
        }
        sb.append(newURI);
        sb.append("\r\n");
        this.m_out.write(HttpServletResponseImpl.buildResponse(301, null, sb.toString(), null));
        this.m_out.flush();
    }

    public void sendNotFoundResponse() throws IOException {
        this.m_out.write(HttpServletResponseImpl.buildResponse(404));
        this.m_out.flush();
    }

    public synchronized void flushBuffer() throws IOException {
        if (this.m_getOutputStreamCalled) {
            this.m_servletOutputStream.flush();
        } else if (this.m_getWriterCalled) {
            this.m_printWriter.flush();
        }
        if (!this.m_headersWritten) {
            this.writeHeaders(true);
        }
        if (this.m_buffer != null) {
            byte[] content = this.m_buffer.toByteArray();
            HttpServletResponseImpl.copy(new ByteArrayInputStream(content), this.m_out);
            this.m_out.flush();
        }
    }

    public int getBufferSize() {
        if (this.m_buffer != null) {
            return this.m_buffer.size();
        }
        return this.m_bufferSize;
    }

    public String getCharacterEncoding() {
        return this.m_characterEncoding;
    }

    public String getContentType() {
        Object contentType = this.m_headers.get("Content-Type");
        if (contentType != null) {
            return contentType.toString();
        }
        return null;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.m_getOutputStreamCalled = true;
        if (this.m_getWriterCalled) {
            throw new IllegalStateException("getWriter method has already been called for this response object.");
        }
        if (this.m_servletOutputStream == null) {
            this.m_buffer = new ByteArrayOutputStream(this.m_bufferSize);
            this.m_servletOutputStream = new ServletOutputStreamImpl(this.m_buffer);
        }
        return this.m_servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        this.m_getWriterCalled = true;
        if (this.m_getOutputStreamCalled) {
            throw new IllegalStateException("getOutputStream method has already been called for this response object.");
        }
        if (this.m_printWriter == null) {
            this.m_buffer = new ByteArrayOutputStream(this.m_bufferSize);
            this.m_printWriter = new PrintWriter(this.m_buffer);
        }
        return this.m_printWriter;
    }

    public boolean isCommitted() {
        return this.m_headersWritten;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed.");
        }
        this.m_buffer.reset();
        this.m_printWriter = null;
        this.m_servletOutputStream = null;
        this.m_getOutputStreamCalled = false;
        this.m_getWriterCalled = false;
        this.m_headers.clear();
        this.m_statusCode = 200;
        this.m_customStatusMessage = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed.");
        }
        this.m_buffer.reset();
        this.m_printWriter = null;
        this.m_servletOutputStream = null;
        this.m_getOutputStreamCalled = false;
        this.m_getWriterCalled = false;
    }

    public void setBufferSize(int arg0) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed.");
        }
        this.m_bufferSize = arg0;
    }

    public void setCharacterEncoding(String arg0) {
        this.m_characterEncoding = arg0;
    }

    public void setContentLength(int arg0) {
        this.m_headers.put("Content-Length", Integer.toString(arg0));
    }

    public void setConnectionType(String type) {
        this.setHeader("Connection", type);
    }

    public void setContentType(String arg0) {
        this.setHeader("Content-Type", arg0);
    }

    public void setLocale(Locale arg0) {
        this.m_locale = arg0;
    }

    public void addCookie(Cookie cookie) {
        if (this.m_cookies == null) {
            this.m_cookies = new ArrayList();
        }
        if (!this.m_cookies.contains(cookie)) {
            this.m_cookies.add(cookie);
        }
    }

    public boolean containsHeader(String name) {
        return this.m_headers.get(name) != null;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return this.encodeUrl(url);
    }

    public String encodeUrl(String url) {
        return URLEncoder.encode(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.m_headersWritten) {
            throw new IllegalStateException("Response has already been committed, unable to send error.");
        }
        this.m_out.write(HttpServletResponseImpl.buildResponse(sc, msg));
        this.m_out.flush();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.m_headersWritten) {
            throw new IllegalStateException("Response has already been committed.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Location", location);
        this.m_out.write(HttpServletResponseImpl.buildResponse(307, map, null, null));
        this.m_out.flush();
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, this.m_dateFormat.format(new Date(date)));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, this.m_dateFormat.format(new Date(date)));
    }

    public void setHeader(String name, String value) {
        if (value != null) {
            this.m_headers.put(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (value != null && this.m_headers.containsKey(name)) {
            Object pvalue = this.m_headers.get(name);
            if (pvalue instanceof List) {
                ((List)pvalue).add(value);
            } else {
                ArrayList<Object> vlist = new ArrayList<Object>();
                vlist.add(pvalue);
                vlist.add(value);
            }
        } else {
            this.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        this.m_statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        this.m_statusCode = sc;
        this.m_customStatusMessage = sm;
    }

    public static byte[] buildResponse(int code) {
        return HttpServletResponseImpl.buildResponse(code, null, null, "<html>");
    }

    public static byte[] buildResponse(int code, String userMessage) {
        return HttpServletResponseImpl.buildResponse(code, null, userMessage, "<html>");
    }

    public static byte[] buildResponse(int code, Map headers, String userMessage, String htmlStartTag) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1");
        buffer.append(' ');
        buffer.append(code);
        buffer.append(' ');
        if (code > 399) {
            buffer.append("HTTP Error ");
            buffer.append(code);
        }
        buffer.append("\r\n");
        if (code == 100) {
            buffer.append("\r\n");
        } else if (headers != null) {
            if (headers.containsKey("Content-Type")) {
                HttpServletResponseImpl.appendHeader(buffer, "Content-Type", headers.get("Content-Type").toString());
            }
            Iterator i = headers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (entry.getValue() == null) {
                    throw new IllegalStateException("Header map contains value with null value: " + entry.getKey());
                }
                HttpServletResponseImpl.appendHeader(buffer, entry.getKey().toString(), entry.getValue().toString());
            }
        }
        if (code > 399) {
            if (htmlStartTag == null) {
                htmlStartTag = "<html>";
            }
            buffer.append(htmlStartTag);
            buffer.append("<h1>");
            buffer.append(code);
            buffer.append(' ');
            buffer.append("HTTP Error ");
            buffer.append(code);
            if (userMessage != null) {
                buffer.append("</h1><p>");
                buffer.append(userMessage);
                buffer.append("</p>");
            } else {
                buffer.append("</h1>");
            }
            buffer.append("<h3>Apache Felix Lightweight HTTP Service</h3></html>");
        }
        return buffer.toString().getBytes();
    }

    private byte[] cookieToHeader(Cookie cookie) {
        if (cookie == null || cookie.getName() == null || cookie.getValue() == null) {
            throw new IllegalArgumentException("Invalid cookie");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cookie.getName());
        sb.append('=');
        sb.append(cookie.getValue());
        return sb.toString().getBytes();
    }

    private static void appendHeader(StringBuffer sb, String name, String value) {
        sb.append(name);
        sb.append(": ");
        sb.append(value);
        sb.append("\r\n");
    }
}

