/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqversion.packet.Version;

public class VersionManager
extends Manager {
    private static final Map<XMPPConnection, VersionManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Version own_version;

    private VersionManager(XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("jabber:iq:version");
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                if (VersionManager.this.own_version == null) {
                    return;
                }
                Version reply = new Version(VersionManager.this.own_version);
                reply.setPacketID(packet.getPacketID());
                reply.setTo(packet.getFrom());
                VersionManager.this.connection().sendPacket((Packet)reply);
            }
        }, (PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(Version.class), new IQTypeFilter(IQ.Type.GET)}));
    }

    public static synchronized VersionManager getInstanceFor(XMPPConnection connection) {
        VersionManager versionManager = instances.get(connection);
        if (versionManager == null) {
            versionManager = new VersionManager(connection);
        }
        return versionManager;
    }

    public void setVersion(Version v) {
        this.own_version = v;
    }
}

