/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.util.List;
import org.opennms.features.grpc.exporter.mapper.NmsInventoryMapper;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.plugin.grpc.proto.spog.IpInterface;
import org.opennms.plugin.grpc.proto.spog.NmsInventoryUpdateList;
import org.opennms.plugin.grpc.proto.spog.Node;
import org.opennms.plugin.grpc.proto.spog.SnmpInterface;

public class NmsInventoryMapperImpl
implements NmsInventoryMapper {
    @Override
    public Node toInventoryUpdate(OnmsNode node) {
        if (node == null) {
            return null;
        }
        Node.Builder node1 = Node.newBuilder();
        String locationName = this.nodeLocationLocationName(node);
        if (locationName != null) {
            node1.setLocation(locationName);
        }
        if (node.getSnmpInterfaces() != null) {
            for (OnmsSnmpInterface snmpInterface : node.getSnmpInterfaces()) {
                node1.addSnmpInterface(this.mapSnmpInterface(snmpInterface));
            }
        }
        if (node.getIpInterfaces() != null) {
            for (OnmsIpInterface ipInterface : node.getIpInterfaces()) {
                node1.addIpInterface(this.mapIpInterface(ipInterface));
            }
        }
        if (node.getId() != null) {
            node1.setId(node.getId().intValue());
        }
        if (node.getForeignSource() != null) {
            node1.setForeignSource(node.getForeignSource());
        }
        if (node.getForeignId() != null) {
            node1.setForeignId(node.getForeignId());
        }
        if (node.getLabel() != null) {
            node1.setLabel(node.getLabel());
        }
        if (node.getSysContact() != null) {
            node1.setSysContact(node.getSysContact());
        }
        if (node.getSysDescription() != null) {
            node1.setSysDescription(node.getSysDescription());
        }
        if (node.getSysObjectId() != null) {
            node1.setSysObjectId(node.getSysObjectId());
        }
        if (node.getSysName() != null) {
            node1.setSysName(node.getSysName());
        }
        node1.setCreateTime(this.mapDate(node.getCreateTime()));
        return node1.build();
    }

    @Override
    public SnmpInterface mapSnmpInterface(OnmsSnmpInterface onmsSnmpInterface) {
        if (onmsSnmpInterface == null) {
            return null;
        }
        SnmpInterface.Builder snmpInterface = SnmpInterface.newBuilder();
        if (onmsSnmpInterface.getPhysAddr() != null) {
            snmpInterface.setIfPhysAddress(onmsSnmpInterface.getPhysAddr());
        }
        if (onmsSnmpInterface.getId() != null) {
            snmpInterface.setId(onmsSnmpInterface.getId().intValue());
        }
        if (onmsSnmpInterface.getIfIndex() != null) {
            snmpInterface.setIfIndex(onmsSnmpInterface.getIfIndex());
        }
        if (onmsSnmpInterface.getIfDescr() != null) {
            snmpInterface.setIfDescr(onmsSnmpInterface.getIfDescr());
        }
        if (onmsSnmpInterface.getIfType() != null) {
            snmpInterface.setIfType(onmsSnmpInterface.getIfType());
        }
        if (onmsSnmpInterface.getIfName() != null) {
            snmpInterface.setIfName(onmsSnmpInterface.getIfName());
        }
        if (onmsSnmpInterface.getIfSpeed() != null) {
            snmpInterface.setIfSpeed(onmsSnmpInterface.getIfSpeed());
        }
        if (onmsSnmpInterface.getIfAdminStatus() != null) {
            snmpInterface.setIfAdminStatus(onmsSnmpInterface.getIfAdminStatus());
        }
        if (onmsSnmpInterface.getIfOperStatus() != null) {
            snmpInterface.setIfOperStatus(onmsSnmpInterface.getIfOperStatus());
        }
        if (onmsSnmpInterface.getIfAlias() != null) {
            snmpInterface.setIfAlias(onmsSnmpInterface.getIfAlias());
        }
        return snmpInterface.build();
    }

    @Override
    public IpInterface mapIpInterface(OnmsIpInterface onmsIpInterface) {
        if (onmsIpInterface == null) {
            return null;
        }
        IpInterface.Builder ipInterface = IpInterface.newBuilder();
        if (onmsIpInterface.getMonitoredServices() != null) {
            for (OnmsMonitoredService monitoredService : onmsIpInterface.getMonitoredServices()) {
                ipInterface.addService(this.mapMonitoredService(monitoredService));
            }
        }
        if (onmsIpInterface.getId() != null) {
            ipInterface.setId(onmsIpInterface.getId().intValue());
        }
        if (onmsIpInterface.getIpAddress() != null) {
            ipInterface.setIpAddress(this.mapIpAddress(onmsIpInterface.getIpAddress()));
        }
        ipInterface.setPrimaryType(this.mapPrimaryType(onmsIpInterface));
        return ipInterface.build();
    }

    @Override
    public NmsInventoryUpdateList toInventoryUpdates(List<OnmsNode> inventoryUpdates, RuntimeInfo runtimeInfo, String instanceName, boolean isSnapshot) {
        if (inventoryUpdates == null && runtimeInfo == null && instanceName == null) {
            return null;
        }
        NmsInventoryUpdateList.Builder nmsInventoryUpdateList = NmsInventoryUpdateList.newBuilder();
        if (runtimeInfo != null && runtimeInfo.getSystemId() != null) {
            nmsInventoryUpdateList.setInstanceId(runtimeInfo.getSystemId());
        }
        if (inventoryUpdates != null) {
            for (OnmsNode inventoryUpdate : inventoryUpdates) {
                nmsInventoryUpdateList.addNodes(this.toInventoryUpdate(inventoryUpdate));
            }
        }
        if (instanceName != null) {
            nmsInventoryUpdateList.setInstanceName(instanceName);
        }
        nmsInventoryUpdateList.setSnapshot(isSnapshot);
        return nmsInventoryUpdateList.build();
    }

    private String nodeLocationLocationName(OnmsNode onmsNode) {
        if (onmsNode == null) {
            return null;
        }
        OnmsMonitoringLocation location = onmsNode.getLocation();
        if (location == null) {
            return null;
        }
        String locationName = location.getLocationName();
        if (locationName == null) {
            return null;
        }
        return locationName;
    }
}

