/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.plugin.grpc.proto.spog.IpInterface;
import org.opennms.plugin.grpc.proto.spog.NmsInventoryUpdateList;
import org.opennms.plugin.grpc.proto.spog.Node;
import org.opennms.plugin.grpc.proto.spog.SnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS)
public interface NmsInventoryMapper {
    public static final Logger LOG = LoggerFactory.getLogger(NmsInventoryMapper.class);
    public static final NmsInventoryMapper INSTANCE = (NmsInventoryMapper)Mappers.getMapper(NmsInventoryMapper.class);

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    @Mappings(value={@Mapping(target="location", source="node.location.locationName", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT), @Mapping(target="createTime", expression="java(mapDate(node.getCreateTime()))"), @Mapping(target="snmpInterface", source="snmpInterfaces", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT), @Mapping(target="ipInterface", source="ipInterfaces", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT)})
    public Node toInventoryUpdate(OnmsNode var1);

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    @Mapping(target="ifPhysAddress", source="physAddr")
    public SnmpInterface mapSnmpInterface(OnmsSnmpInterface var1);

    @Mappings(value={@Mapping(target="primaryType", expression="java(mapPrimaryType(onmsIpInterface))"), @Mapping(target="service", source="monitoredServices")})
    public IpInterface mapIpInterface(OnmsIpInterface var1);

    default public String mapMonitoredService(OnmsMonitoredService onmsMonitoredService) {
        return onmsMonitoredService.getServiceName();
    }

    default public long mapDate(Date date) {
        return date != null ? date.getTime() : 0L;
    }

    default public String mapIpAddress(InetAddress inetAddress) {
        return inetAddress != null ? inetAddress.getHostAddress() : null;
    }

    default public String mapPrimaryType(OnmsIpInterface onmsIpInterface) {
        return onmsIpInterface.getIsSnmpPrimary() != null ? onmsIpInterface.getIsSnmpPrimary().getCode() : null;
    }

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    @Mappings(value={@Mapping(target="instanceId", source="runtimeInfo.systemId"), @Mapping(target="instanceName", source="instanceName"), @Mapping(target="nodes", source="inventoryUpdates"), @Mapping(target="snapshot", source="isSnapshot")})
    public NmsInventoryUpdateList toInventoryUpdates(List<OnmsNode> var1, RuntimeInfo var2, String var3, boolean var4);

    default public NmsInventoryUpdateList toInventoryUpdatesList(List<OnmsNode> inventoryUpdates, RuntimeInfo runtimeInfo, String instanceName, boolean snapshot) {
        NmsInventoryUpdateList.Builder builder = this.toInventoryUpdates(inventoryUpdates, runtimeInfo, instanceName, snapshot).toBuilder();
        return builder.build();
    }
}

