/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.perspectivepoller;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Objects;
import org.opennms.core.rpc.api.RpcExceptionHandler;
import org.opennms.core.rpc.api.RpcExceptionUtils;
import org.opennms.netmgt.perspectivepoller.PerspectivePolledService;
import org.opennms.netmgt.perspectivepoller.PerspectivePollerd;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectivePollJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(PerspectivePollJob.class);
    public static final String SERVICE = "service";
    public static final String BACKEND = "backend";
    public static final String TRACER = "tracer";

    public void execute(JobExecutionContext context) {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        PerspectivePolledService svc = Objects.requireNonNull((PerspectivePolledService)dataMap.get((Object)SERVICE), "service required");
        PerspectivePollerd backend = Objects.requireNonNull((PerspectivePollerd)dataMap.get((Object)BACKEND), "backend required");
        Tracer tracer = Objects.requireNonNull((Tracer)dataMap.get((Object)TRACER), "tracer required");
        LOG.debug("Poll triggered for {}", (Object)svc);
        Span span = tracer.buildSpan("PerspectivePoller").start();
        span.setTag("location", svc.getPerspectiveLocation());
        span.setTag("thread", Thread.currentThread().getName());
        backend.getLocationAwarePollerClient().poll().withService(svc.getMonitoredService()).withTimeToLive(svc.getServiceConfig().getInterval()).withMonitorLocator(svc.getServiceMonitorLocator()).withAttributes(svc.getServiceConfig().getParameterMap()).withPatternVariables(svc.getPatternVariables()).execute().whenComplete((res, ex) -> {
            if (ex == null) {
                LOG.debug("Poll for {} completed successfully: {}", (Object)svc, res);
                backend.reportResult(svc, res.getPollStatus());
                backend.persistResponseTimeData(svc, res.getPollStatus());
            } else {
                span.setTag("thread", "true");
                span.log(ex.getMessage());
                RpcExceptionUtils.handleException((Throwable)ex, (RpcExceptionHandler)new RpcExceptionHandler<Void>(){

                    public Void onInterrupted(Throwable t) {
                        LOG.warn("Interrupted.");
                        return null;
                    }

                    public Void onTimedOut(Throwable t) {
                        LOG.warn("RPC timed out.", t);
                        return null;
                    }

                    public Void onRejected(Throwable t) {
                        LOG.warn("Rejected call.", t);
                        return null;
                    }

                    public Void onUnknown(Throwable t) {
                        LOG.warn("Unknown exception.", t);
                        return null;
                    }
                });
            }
            span.finish();
        });
    }
}

