/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.client.rpc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupRequestDTO;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupResponseDTO;
import org.opennms.netmgt.provision.dns.client.rpc.QueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class DnsLookupClientRpcModule
extends AbstractXmlRpcModule<DnsLookupRequestDTO, DnsLookupResponseDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(DnsLookupClientRpcModule.class);
    public static final String RPC_MODULE_ID = "DNS";
    private final ExecutorService executorService;

    public DnsLookupClientRpcModule(int threadCount) {
        super(DnsLookupRequestDTO.class, DnsLookupResponseDTO.class);
        this.executorService = Executors.newFixedThreadPool(threadCount);
        LOG.debug("Configuring fixed-sized ThreadPool using threadCount={}", (Object)threadCount);
    }

    public DnsLookupResponseDTO createResponseWithException(Throwable ex) {
        return new DnsLookupResponseDTO(ex);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public CompletableFuture<DnsLookupResponseDTO> execute(DnsLookupRequestDTO request) {
        return CompletableFuture.supplyAsync(() -> {
            InetAddress addr = InetAddressUtils.addr((String)request.getHostRequest());
            DnsLookupResponseDTO dto = new DnsLookupResponseDTO();
            QueryType queryType = request.getQueryType();
            if (queryType.equals((Object)QueryType.LOOKUP)) {
                dto.setHostResponse(addr.getHostAddress());
            } else if (queryType.equals((Object)QueryType.REVERSE_LOOKUP)) {
                String hostName = addr.getCanonicalHostName();
                if (InetAddressUtils.str((InetAddress)addr).equals(hostName)) {
                    try {
                        hostName = Address.getHostName((InetAddress)addr);
                    }
                    catch (UnknownHostException e) {
                        LOG.warn("Failed to retrieve the fully qualified domain name for {}. Using the textual representation of the IP address.", (Object)addr);
                    }
                }
                dto.setHostResponse(hostName);
            }
            return dto;
        }, this.executorService);
    }
}

