/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.features.apilayer.config.ResourceTypesExtensionManager;
import org.opennms.integration.api.v1.config.datacollection.Group;
import org.opennms.integration.api.v1.config.datacollection.MibObjProperty;
import org.opennms.integration.api.v1.config.datacollection.SnmpCollectionExtension;
import org.opennms.integration.api.v1.config.datacollection.SnmpDataCollection;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.Collect;
import org.opennms.netmgt.config.datacollection.DataCollectionGroups;
import org.opennms.netmgt.config.datacollection.DatacollectionGroup;
import org.opennms.netmgt.config.datacollection.IpList;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.config.datacollection.SystemDef;

public class SnmpCollectionExtensionManager
extends ConfigExtensionManager<SnmpCollectionExtension, DataCollectionGroups> {
    private final DataCollectionConfigDao dataCollectionConfigDao;

    public SnmpCollectionExtensionManager(DataCollectionConfigDao dataCollectionConfigDao) {
        super(DataCollectionGroups.class, new DataCollectionGroups());
        this.dataCollectionConfigDao = dataCollectionConfigDao;
    }

    @Override
    protected DataCollectionGroups getConfigForExtensions(Set<SnmpCollectionExtension> extensions) {
        DataCollectionGroups dataCollectionGroups = new DataCollectionGroups();
        extensions.forEach(extension -> dataCollectionGroups.addDataCollectionGroup(extension.getSnmpCollectionName(), SnmpCollectionExtensionManager.toDataCollectionGroups(extension)));
        return dataCollectionGroups;
    }

    @Override
    protected void triggerReload() {
        this.dataCollectionConfigDao.reload();
    }

    public static List<DatacollectionGroup> toDataCollectionGroups(SnmpCollectionExtension extension) {
        return extension.getSnmpDataCollectionGroups().stream().map(SnmpCollectionExtensionManager::toDataCollectionGroup).collect(Collectors.toList());
    }

    public static DatacollectionGroup toDataCollectionGroup(SnmpDataCollection snmpDataCollection) {
        DatacollectionGroup datacollectionGroup = new DatacollectionGroup();
        datacollectionGroup.setName(snmpDataCollection.getName());
        datacollectionGroup.setGroups(snmpDataCollection.getGroups().stream().map(SnmpCollectionExtensionManager::toGroup).collect(Collectors.toList()));
        datacollectionGroup.setSystemDefs(snmpDataCollection.getSystemDefs().stream().map(SnmpCollectionExtensionManager::toSystemDef).collect(Collectors.toList()));
        datacollectionGroup.setResourceTypes(snmpDataCollection.getResourceTypes().stream().map(ResourceTypesExtensionManager::toResourceType).collect(Collectors.toList()));
        return datacollectionGroup;
    }

    public static org.opennms.netmgt.config.datacollection.Group toGroup(Group grp) {
        org.opennms.netmgt.config.datacollection.Group group = new org.opennms.netmgt.config.datacollection.Group();
        group.setIfType(grp.getIfType());
        group.setName(grp.getName());
        group.setIncludeGroups(grp.getIncludeGroups());
        group.setMibObjs(grp.getMibObjs().stream().map(SnmpCollectionExtensionManager::toMibObj).collect(Collectors.toList()));
        group.setProperties(grp.getProperties().stream().map(SnmpCollectionExtensionManager::toMibObjProperty).collect(Collectors.toList()));
        return group;
    }

    public static MibObj toMibObj(org.opennms.integration.api.v1.config.datacollection.MibObj mibo) {
        MibObj mibObj = new MibObj();
        mibObj.setAlias(mibo.getAlias());
        mibObj.setInstance(mibo.getInstance());
        mibObj.setMaxval(mibo.getMaxval());
        mibObj.setMinval(mibo.getMinval());
        mibObj.setOid(mibo.getOid());
        mibObj.setType(mibo.getType());
        return mibObj;
    }

    public static org.opennms.netmgt.config.datacollection.MibObjProperty toMibObjProperty(MibObjProperty objProperty) {
        org.opennms.netmgt.config.datacollection.MibObjProperty mibObjProperty = new org.opennms.netmgt.config.datacollection.MibObjProperty();
        mibObjProperty.setAlias(objProperty.getAlias());
        mibObjProperty.setClassName(objProperty.getClassName());
        mibObjProperty.setInstance(objProperty.getInstance());
        mibObjProperty.setParameters(objProperty.getParameters().stream().map(SnmpCollectionExtensionManager::toParameter).collect(Collectors.toList()));
        return mibObjProperty;
    }

    public static SystemDef toSystemDef(org.opennms.integration.api.v1.config.datacollection.SystemDef sysDef) {
        SystemDef systemDef = new SystemDef();
        systemDef.setName(sysDef.getName());
        systemDef.setSysoid(sysDef.getSysoid());
        systemDef.setSysoidMask(sysDef.getSysoidMask());
        if (sysDef.getCollect() != null) {
            Collect collect = new Collect();
            collect.setIncludeGroups(sysDef.getCollect().getIncludeGroups());
            systemDef.setCollect(collect);
        }
        if (sysDef.getIpList() != null) {
            IpList ipList = new IpList();
            ipList.setIpAddresses(sysDef.getIpList().getIpAddresses());
            ipList.setIpAddressMasks(sysDef.getIpList().getIpAddressMasks());
            systemDef.setIpList(ipList);
        }
        return systemDef;
    }

    public static Parameter toParameter(final org.opennms.integration.api.v1.config.datacollection.Parameter parameter) {
        return new Parameter(){

            public String getKey() {
                return parameter.getKey();
            }

            public String getValue() {
                return parameter.getValue();
            }
        };
    }
}

