/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.persistence.impl;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;

public class IpNetToMediaDaoHibernate
extends AbstractDaoHibernate<IpNetToMedia, Integer>
implements IpNetToMediaDao {
    public IpNetToMediaDaoHibernate() {
        super(IpNetToMedia.class);
    }

    @Override
    public List<IpNetToMedia> findBySourceNodeId(Integer id) {
        return this.find("from IpNetToMedia rec where rec.sourceNode.id = ?", id);
    }

    @Override
    public IpNetToMedia getByNetAndPhysAddress(InetAddress netAddress, String physAddress) {
        return (IpNetToMedia)this.findUnique("from IpNetToMedia rec where rec.netAddress = ? and rec.physAddress = ?", netAddress, physAddress);
    }

    @Override
    public void deleteBySourceNodeIdOlderThen(Integer nodeId, Date now) {
        for (IpNetToMedia elem : this.find("from IpNetToMedia rec where rec.sourceNode.id = ? and rec.lastPollTime < ?", nodeId, now)) {
            this.delete(elem);
        }
    }

    @Override
    public void deleteBySourceNodeId(Integer nodeId) {
        for (IpNetToMedia elem : this.find("from IpNetToMedia rec where rec.sourceNode.id = ? ", nodeId)) {
            this.delete(elem);
        }
    }

    @Override
    public List<IpNetToMedia> findByPhysAddress(String physAddress) {
        return this.find("from IpNetToMedia rec where rec.physAddress = ?", physAddress);
    }

    @Override
    public List<IpNetToMedia> findByNetAddress(InetAddress netAddress) {
        return this.find("from IpNetToMedia rec where rec.netAddress = ? ", netAddress);
    }

    @Override
    public List<IpNetToMedia> findByMacLinksOfNode(Integer nodeId) {
        return this.find("from IpNetToMedia m where m.physAddress in (select l.macAddress from BridgeMacLink l where l.node.id = ?)", nodeId);
    }

    @Override
    public void deleteAll() {
        this.getHibernateTemplate().bulkUpdate("delete from IpNetToMedia");
    }
}

