/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb.collector;

import java.io.File;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.dao.jaxb.collector.CollectdConfigVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class CollectdConfigFile {
    private static final Logger LOG = LoggerFactory.getLogger(CollectdConfigFile.class);
    File m_file;

    public CollectdConfigFile(File file) {
        this.m_file = file;
    }

    public void visit(CollectdConfigVisitor visitor) {
        CollectdConfiguration collectdConfiguration = this.getCollectdConfiguration();
        visitor.visitCollectdConfiguration(collectdConfiguration);
        for (Collector collector : collectdConfiguration.getCollectors()) {
            this.doVisit(collector, visitor);
        }
        visitor.completeCollectdConfiguration(collectdConfiguration);
    }

    private void doVisit(Collector collector, CollectdConfigVisitor visitor) {
        visitor.visitCollectorCollection(collector);
        visitor.completeCollectorCollection(collector);
    }

    private CollectdConfiguration getCollectdConfiguration() {
        return (CollectdConfiguration)JaxbUtils.unmarshal(CollectdConfiguration.class, (Resource)new FileSystemResource(this.m_file));
    }
}

