/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.dao.api.SiteStatusViewConfigDao;
import org.opennms.netmgt.dao.jaxb.SiteStatusViewsFactory;
import org.springframework.dao.DataRetrievalFailureException;

public class DefaultSiteStatusViewConfigDao
implements SiteStatusViewConfigDao {
    @Override
    public View getView(String viewName) {
        try {
            return SiteStatusViewsFactory.getInstance().getView(viewName);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load site status view config file", (Throwable)e);
        }
    }

    @Override
    public List<View> getViews() {
        return SiteStatusViewsFactory.getConfig().getViews();
    }

    public Map<String, View> getViewMap() {
        return Collections.unmodifiableMap(SiteStatusViewsFactory.getViewsMap());
    }

    @Override
    public View getDefaultView() {
        String defaultView = SiteStatusViewsFactory.getConfig().getDefaultView();
        return this.getView(defaultView);
    }

    static {
        try {
            SiteStatusViewsFactory.init();
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Unable to locate site status view config file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load site status view config file", (Throwable)e);
        }
    }
}

