/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.users;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DutySchedule {
    private static final Logger LOG = LoggerFactory.getLogger(DutySchedule.class);
    private BitSet m_days;
    private int m_startTime;
    private int m_stopTime;
    public static final int MONDAY = 0;
    public static final int TUESDAY = 1;
    public static final int WEDNESDAY = 2;
    public static final int THURSDAY = 3;
    public static final int FRIDAY = 4;
    public static final int SATURDAY = 5;
    public static final int SUNDAY = 6;
    public static final String[] DAY_NAMES = new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};
    private static final int[] CALENDAR_DAY_MAPPING = new int[]{2, 3, 4, 5, 6, 7, 1};

    public DutySchedule() {
        this.m_days = new BitSet(7);
    }

    public DutySchedule(Vector<Object> aSchedule) {
        this.m_days = new BitSet(7);
        for (int i = 0; i < 7; ++i) {
            if (!((Boolean)aSchedule.get(i)).booleanValue()) continue;
            this.m_days.set(i);
        }
        this.m_startTime = Integer.parseInt((String)aSchedule.get(7));
        this.m_stopTime = Integer.parseInt((String)aSchedule.get(8));
    }

    public DutySchedule(List<Boolean> schedule, int start, int end) {
        Assert.notNull(schedule, (String)"argument schedule must not be null");
        Assert.isTrue((schedule.size() == 7 ? 1 : 0) != 0, (String)"argument schedule must contain exactly seven Boolean objects");
        this.m_days = new BitSet(7);
        for (int i = 0; i < 7; ++i) {
            this.m_days.set(i, schedule.get(i));
        }
        this.m_startTime = start;
        this.m_stopTime = end;
    }

    public DutySchedule(String aSchedule) {
        this.m_days = new BitSet(7);
        StringTokenizer timeTokens = new StringTokenizer(aSchedule, "-");
        String daysAndStartTime = timeTokens.nextToken();
        this.m_stopTime = Integer.parseInt(timeTokens.nextToken());
        for (int j = 0; j < daysAndStartTime.length(); ++j) {
            if (Character.isDigit(daysAndStartTime.charAt(j))) {
                this.m_startTime = Integer.parseInt(daysAndStartTime.substring(j, daysAndStartTime.length()));
                break;
            }
            this.m_days.set(this.getDayInt(daysAndStartTime.substring(j++, j + 1)));
        }
    }

    private int getDayInt(String aDay) {
        int value = -1;
        for (int i = 0; i < DAY_NAMES.length; ++i) {
            if (!aDay.equals(DAY_NAMES[i])) continue;
            value = i;
            break;
        }
        return value;
    }

    public void setDay(int aDay) {
        this.m_days.set(aDay);
    }

    public int getStartTime() {
        return this.m_startTime;
    }

    public int getStopTime() {
        return this.m_stopTime;
    }

    public Vector<Object> getAsVector() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < 7; ++i) {
            vector.add(this.m_days.get(i));
        }
        vector.add(String.valueOf(this.m_startTime));
        vector.add(String.valueOf(this.m_stopTime));
        return vector;
    }

    public boolean isInSchedule(Calendar aTime) {
        boolean response = false;
        GregorianCalendar startTime = new GregorianCalendar(aTime.get(1), aTime.get(2), aTime.get(5));
        startTime.set(11, this.m_startTime / 100);
        startTime.set(12, this.m_startTime % 100);
        startTime.set(13, 0);
        GregorianCalendar endTime = new GregorianCalendar(aTime.get(1), aTime.get(2), aTime.get(5));
        endTime.set(11, this.m_stopTime / 100);
        endTime.set(12, this.m_stopTime % 100);
        endTime.set(13, 0);
        for (int i = 0; i < 7; ++i) {
            if (!this.m_days.get(i) || CALENDAR_DAY_MAPPING[i] != aTime.get(7)) continue;
            long dateMillis = aTime.getTime().getTime();
            long startMillis = startTime.getTime().getTime();
            long endMillis = endTime.getTime().getTime();
            if (startMillis > dateMillis || dateMillis > endMillis) continue;
            response = true;
            break;
        }
        return response;
    }

    public long nextInSchedule(Calendar nTime) {
        long next = -1L;
        long tempnext = -1L;
        GregorianCalendar startTime = new GregorianCalendar(nTime.get(1), nTime.get(2), nTime.get(5));
        startTime.set(11, this.m_startTime / 100);
        startTime.set(12, this.m_startTime % 100);
        startTime.set(13, 0);
        GregorianCalendar endTime = new GregorianCalendar(nTime.get(1), nTime.get(2), nTime.get(5));
        endTime.set(11, this.m_stopTime / 100);
        endTime.set(12, this.m_stopTime % 100);
        endTime.set(13, 0);
        long dateMillis = nTime.getTime().getTime();
        long startMillis = startTime.getTime().getTime();
        long endMillis = endTime.getTime().getTime();
        int itoday = -1;
        for (int i = 0; i < 7; ++i) {
            if (CALENDAR_DAY_MAPPING[i] == nTime.get(7)) {
                itoday = i;
                LOG.debug("nextInSchedule: day of week is {}", (Object)i);
            }
            if (!this.m_days.get(i) || CALENDAR_DAY_MAPPING[i] != nTime.get(7)) continue;
            LOG.debug("nextInSchedule: Today is in schedule");
            if (startMillis > dateMillis) {
                next = startMillis - dateMillis;
                LOG.debug("nextInSchedule: duty starts in {} millisec", (Object)next);
                continue;
            }
            if (endMillis < dateMillis) continue;
            next = 0L;
            LOG.debug("nextInSchedule: on duty now");
        }
        if (next >= 0L) {
            return next;
        }
        LOG.debug("nextInSchedule: Remainder of today is not in schedule");
        int ndays = -1;
        for (int i = 0; i < 7; ++i) {
            if (!this.m_days.get(i)) continue;
            LOG.debug("nextInSchedule: day {} is in schedule", (Object)i);
            ndays = i - itoday;
            if (ndays <= 0) {
                ndays += 7;
            }
            LOG.debug("nextInSchedule: day {} is {} from today", (Object)i, (Object)ndays);
            tempnext = 86400000L * (long)ndays - dateMillis + startMillis;
            if (tempnext >= next && next != -1L) continue;
            next = tempnext;
            LOG.debug("nextInSchedule: duty begins in {} millisecs", (Object)next);
        }
        return next;
    }

    public void setStartHour(int anHour) {
        this.m_startTime = anHour;
    }

    public void setEndHour(int anHour) {
        this.m_stopTime = anHour;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < DAY_NAMES.length; ++i) {
            if (!this.m_days.get(i)) continue;
            buffer.append(DAY_NAMES[i]);
        }
        buffer.append(this.m_startTime + "-" + this.m_stopTime);
        return buffer.toString();
    }

    public boolean isInSchedule(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return this.isInSchedule(cal);
    }

    public boolean hasDay(int aDay) {
        return this.m_days.get(aDay);
    }
}

