/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpAsset.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.snmpAsset.adapter.MibObj;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="assetField")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-asset-adapter-configuration.xsd")
public class AssetField
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="formatString", required=true)
    private String m_formatString;
    @XmlElementWrapper(name="mibObjs", required=true)
    @XmlElement(name="mibObj", required=true)
    private List<MibObj> m_mibObjs = new ArrayList<MibObj>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getFormatString() {
        return this.m_formatString;
    }

    public void setFormatString(String formatString) {
        this.m_formatString = ConfigUtils.assertNotEmpty(formatString, "formatString");
    }

    public List<MibObj> getMibObjs() {
        return this.m_mibObjs;
    }

    public void setMibObjs(List<MibObj> mibObjs) {
        ConfigUtils.assertMinimumSize(mibObjs, 1L, "mibObj");
        if (mibObjs == this.m_mibObjs) {
            return;
        }
        this.m_mibObjs.clear();
        if (mibObjs != null) {
            this.m_mibObjs.addAll(mibObjs);
        }
    }

    public void addMibObj(MibObj mibObj) {
        this.m_mibObjs.add(mibObj);
    }

    public boolean removeMibObj(MibObj mibObj) {
        return this.m_mibObjs.remove(mibObj);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_formatString, this.m_mibObjs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AssetField) {
            AssetField that = (AssetField)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_formatString, that.m_formatString) && Objects.equals(this.m_mibObjs, that.m_mibObjs);
        }
        return false;
    }
}

