/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.hardware;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.hardware.HwExtension;
import org.opennms.netmgt.config.hardware.MibObj;
import org.opennms.netmgt.snmp.SnmpObjId;

@XmlRootElement(name="hardware-inventory-adapter-configuration")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="snmp-hardware-inventory-adapter-configuration.xsd")
public class HwInventoryAdapterConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<HwExtension> m_extensions = new ArrayList<HwExtension>();

    @XmlElement(name="hw-extension")
    public List<HwExtension> getExtensions() {
        return this.m_extensions;
    }

    public void setExtensions(List<HwExtension> extensions) {
        if (extensions == this.m_extensions) {
            return;
        }
        this.m_extensions.clear();
        if (extensions != null) {
            this.m_extensions.addAll(extensions);
        }
    }

    public void addExtension(HwExtension extension) {
        this.m_extensions.add(extension);
    }

    public List<SnmpObjId> getVendorOid(String nodeSysOid) {
        ArrayList<SnmpObjId> vendorOidList = new ArrayList<SnmpObjId>();
        for (HwExtension ext : this.getExtensions()) {
            if (!nodeSysOid.startsWith(ext.getSysOidMask())) continue;
            for (MibObj obj : ext.getMibObjects()) {
                vendorOidList.add(obj.getOid());
            }
        }
        return vendorOidList;
    }

    public Map<String, String> getReplacementMap() {
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (HwExtension ext : this.getExtensions()) {
            for (MibObj obj : ext.getMibObjects()) {
                if (!obj.getReplace().isPresent() || obj.getReplace().get().trim().isEmpty()) continue;
                replacementMap.put(obj.getAlias(), obj.getReplace().get());
            }
        }
        return replacementMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HwInventoryAdapterConfiguration) {
            HwInventoryAdapterConfiguration that = (HwInventoryAdapterConfiguration)obj;
            return Objects.equals(this.m_extensions, that.m_extensions);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_extensions);
    }

    public String toString() {
        return "HwInventoryAdapterConfiguration [extensions=" + this.m_extensions + "]";
    }
}

