/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.Join;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="table")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="database-schema.xsd")
public class Table
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_VISIBLE = "true";
    private static final String DEFAULT_KEY = "secondary";
    @XmlAttribute(name="visible")
    private String m_visible;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="key")
    private String m_key;
    @XmlElement(name="join")
    private List<Join> m_joins = new ArrayList<Join>();
    @XmlElement(name="column", required=true)
    private List<Column> m_columns = new ArrayList<Column>();

    public String getVisible() {
        return this.m_visible != null ? this.m_visible : DEFAULT_VISIBLE;
    }

    public void setVisible(String visible) {
        this.m_visible = ConfigUtils.normalizeString(visible);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getKey() {
        return this.m_key != null ? this.m_key : DEFAULT_KEY;
    }

    public void setKey(String key) {
        this.m_key = ConfigUtils.normalizeString(key);
    }

    public List<Join> getJoins() {
        return this.m_joins;
    }

    public void setJoins(List<Join> joins) {
        if (joins == this.m_joins) {
            return;
        }
        this.m_joins.clear();
        if (joins != null) {
            this.m_joins.addAll(joins);
        }
    }

    public void addJoin(Join join) {
        this.m_joins.add(join);
    }

    public boolean removeJoin(Join join) {
        return this.m_joins.remove(join);
    }

    public List<Column> getColumns() {
        return this.m_columns;
    }

    public void setColumns(List<Column> columns) {
        if (columns == this.m_columns) {
            return;
        }
        this.m_columns.clear();
        if (columns != null) {
            this.m_columns.addAll(columns);
        }
    }

    public void addColumn(Column column) {
        this.m_columns.add(column);
    }

    public boolean removeColumn(Column column) {
        return this.m_columns.remove(column);
    }

    public int hashCode() {
        int hash = Objects.hash(this.m_visible, this.m_name, this.m_key, this.m_joins, this.m_columns);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Table) {
            Table that = (Table)obj;
            return Objects.equals(this.m_visible, that.m_visible) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_key, that.m_key) && Objects.equals(this.m_joins, that.m_joins) && Objects.equals(this.m_columns, that.m_columns);
        }
        return false;
    }
}

