/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.categories;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Common;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="categorygroup")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="categories.xsd")
public class CategoryGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="comment")
    private String m_comment;
    @XmlElement(name="common", required=true)
    private Common m_common;
    @XmlElementWrapper(name="categories")
    @XmlElement(name="category")
    private List<Category> m_categories = new ArrayList<Category>();

    public CategoryGroup() {
    }

    public CategoryGroup(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.m_comment);
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public Common getCommon() {
        return this.m_common;
    }

    public void setCommon(Common common) {
        this.m_common = common == null ? new Common() : common;
    }

    public void setCommonRule(String rule) {
        if (this.m_common == null) {
            this.m_common = new Common();
        }
        this.m_common.setRule(rule);
    }

    public List<Category> getCategories() {
        return this.m_categories;
    }

    public void setCategories(List<Category> categories) {
        if (categories == this.m_categories) {
            return;
        }
        this.m_categories.clear();
        if (categories != null) {
            this.m_categories.addAll(categories);
        }
    }

    public void addCategory(Category cat) {
        this.m_categories.add(cat);
    }

    public boolean removeCategory(Category cat) {
        return this.m_categories.remove(cat);
    }

    public void removeCategory(String label) {
        this.m_categories.removeIf(cat -> cat.getLabel().equals(label));
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_comment, this.m_common, this.m_categories);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CategoryGroup) {
            CategoryGroup temp = (CategoryGroup)obj;
            return Objects.equals(temp.m_name, this.m_name) && Objects.equals(temp.m_comment, this.m_comment) && Objects.equals(temp.m_common, this.m_common) && Objects.equals(temp.m_categories, this.m_categories);
        }
        return false;
    }

    public String toString() {
        return "CategoryGroup [name=" + this.m_name + ", comment=" + this.m_comment + ", common=" + this.m_common + ", categories=" + this.m_categories + "]";
    }
}

