/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ackd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.config.ackd.ReaderSchedule;

@XmlRootElement(name="reader")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ackd-configuration.xsd")
public class Reader
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final boolean DEFAULT_ENABLED_FLAG = true;
    @XmlAttribute(name="reader-name")
    private String m_readerName;
    @XmlAttribute(name="enabled")
    private Boolean m_enabled;
    @XmlElement(name="reader-schedule")
    private ReaderSchedule m_readerSchedule;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public Reader() {
    }

    public Reader(String name, boolean enabled, ReaderSchedule schedule, List<Parameter> parameters) {
        this.setReaderName(name);
        this.setEnabled(enabled);
        this.setReaderSchedule(schedule);
        this.setParameters(parameters);
    }

    public String getReaderName() {
        return this.m_readerName;
    }

    public void setReaderName(String readerName) {
        this.m_readerName = readerName;
    }

    public boolean getEnabled() {
        return this.m_enabled == null ? true : this.m_enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
    }

    public ReaderSchedule getReaderSchedule() {
        return this.m_readerSchedule;
    }

    public void setReaderSchedule(ReaderSchedule readerSchedule) {
        this.m_readerSchedule = readerSchedule;
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (this.m_parameters == parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public int hashCode() {
        return Objects.hash(this.m_readerName, this.m_enabled, this.m_readerSchedule, this.m_parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Reader) {
            Reader that = (Reader)obj;
            return Objects.equals(this.m_readerName, that.m_readerName) && Objects.equals(this.m_enabled, that.m_enabled) && Objects.equals(this.m_readerSchedule, that.m_readerSchedule) && Objects.equals(this.m_parameters, that.m_parameters);
        }
        return false;
    }
}

