/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.grafana;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.netmgt.endpoints.grafana.api.Dashboard;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClient;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClientFactory;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpoint;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpointService;
import org.opennms.netmgt.endpoints.grafana.client.GrafanaClientImpl;
import org.opennms.netmgt.endpoints.grafana.client.GrafanaServerConfiguration;
import org.opennms.netmgt.jasper.grafana.GrafanaPanelDatasource;
import org.opennms.netmgt.jasper.grafana.GrafanaQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaQueryExecutor
extends JRAbstractQueryExecuter {
    private static final Logger LOG = LoggerFactory.getLogger(GrafanaQueryExecutor.class);
    private static final String GRAFANA_ENDPOINT_UID_PARM = "GRAFANA_ENDPOINT_UID";
    private static final ServiceLookup<Class<?>, String> SERVICE_LOOKUP = new ServiceLookupBuilder(new ServiceRegistryLookup(DefaultServiceRegistry.INSTANCE)).blocking().build();

    public GrafanaQueryExecutor(JasperReportsContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(context, dataset, parameters);
        if (dataset != null) {
            this.parseQuery();
        }
    }

    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    public GrafanaPanelDatasource createDatasource() throws JRException {
        GrafanaClient client;
        String queryString = this.getQueryString();
        LOG.debug("Create datasource for query '{}'", (Object)queryString);
        GrafanaQuery grafanaQuery = new GrafanaQuery(queryString);
        LOG.debug("Parsed query: {}", (Object)grafanaQuery);
        String grafanaEndpointUid = this.getStringParameterOrProperty(GRAFANA_ENDPOINT_UID_PARM);
        if (Strings.isNullOrEmpty(grafanaEndpointUid)) {
            LOG.debug("No Grafana endpoint UID was set, using server configuration from the user's environment.");
            GrafanaServerConfiguration config = GrafanaServerConfiguration.fromEnv();
            client = new GrafanaClientImpl(config);
        } else {
            GrafanaEndpointService grafanaEndpointService = (GrafanaEndpointService)SERVICE_LOOKUP.lookup(GrafanaEndpointService.class, null);
            GrafanaEndpoint grafanaEndpointDefinition = grafanaEndpointService.getEndpointByUid(grafanaEndpointUid);
            if (grafanaEndpointDefinition == null) {
                throw new IllegalArgumentException("No endpoint definition found for UID: " + grafanaEndpointUid);
            }
            GrafanaClientFactory grafanaClientFactory = (GrafanaClientFactory)SERVICE_LOOKUP.lookup(GrafanaClientFactory.class, null);
            client = grafanaClientFactory.createClient(grafanaEndpointDefinition);
        }
        try {
            Dashboard dashboard = client.getDashboardByUid(grafanaQuery.getDashboardUid());
            return new GrafanaPanelDatasource(client, dashboard, grafanaQuery);
        }
        catch (IOException e) {
            throw new JRException((Throwable)e);
        }
    }

    public void close() {
    }

    public boolean cancelQuery() {
        return false;
    }
}

