/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class SimpleNamespaceFilter
extends XMLFilterImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleNamespaceFilter.class);
    private String m_namespaceUri;
    private boolean m_addNamespace = false;
    private boolean m_addedNamespace = false;

    public SimpleNamespaceFilter(String namespaceUri, boolean addNamespace) {
        LOG.trace("SimpleNamespaceFilter initalized with namespace {} ({})", (Object)namespaceUri, (Object)addNamespace);
        this.m_namespaceUri = addNamespace ? namespaceUri.intern() : "".intern();
        this.m_addNamespace = addNamespace;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.m_addNamespace) {
            this.startControlledPrefixMapping();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.m_addNamespace) {
            LOG.trace("start: uri = {}, new uri = {}, localName = {}, qName = {}, attributes = {}", uri, this.m_namespaceUri, localName, qName, attributes);
            String type = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type != null) {
                AttributesImpl att = new AttributesImpl();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getLocalName(i).equals("type") && attributes.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                    att.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                }
                super.startElement(this.m_namespaceUri, localName, qName, att);
            } else {
                super.startElement(this.m_namespaceUri, localName, qName, attributes);
            }
        } else {
            LOG.trace("start: uri = {}, new uri = {}, localName = {}, qName = {}, attributes = {}", uri, uri, localName, qName, attributes);
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_addNamespace) {
            LOG.trace("end:   uri = {}, new uri = {}, localName = {}, qName = {}", uri, this.m_namespaceUri, localName, qName);
            super.endElement(this.m_namespaceUri, localName, qName);
        } else {
            LOG.trace("end:   uri = {}, new uri = {}, localName = {}, qName = {}", uri, uri, localName, qName);
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String url) throws SAXException {
        LOG.trace("startPrefixMapping: prefix = {}, url = {}", (Object)prefix, (Object)url);
        if (this.m_addNamespace) {
            this.startControlledPrefixMapping();
        } else {
            super.startPrefixMapping(prefix, url);
        }
    }

    private void startControlledPrefixMapping() throws SAXException {
        LOG.trace("startControlledPrefixMapping");
        if (this.m_addNamespace && !this.m_addedNamespace) {
            super.startPrefixMapping("".intern(), this.m_namespaceUri);
            this.m_addedNamespace = true;
        }
    }

    public String toString() {
        return "SimpleNamespaceFilter[namespaceUri=" + this.m_namespaceUri + ",addNamespace=" + this.m_addNamespace + "]";
    }
}

