/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.evaluate;

import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluateGroupPersister;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluateSinglePersister;
import org.opennms.netmgt.collection.persistence.evaluate.EvaluateStats;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.springframework.util.Assert;

public class EvaluatePersisterFactory
implements PersisterFactory {
    private EvaluateStats stats;

    public EvaluatePersisterFactory(EvaluateStats stats) {
        Assert.notNull((Object)stats, (String)"EvaluateStats is required");
        this.stats = stats;
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        return this.createPersister(params, repository, false, false, false);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        if (ResourceTypeUtils.isStoreByGroup() || forceStoreByGroup) {
            return this.createGroupPersister(params, repository, dontPersistCounters);
        }
        return this.createOneToOnePersister(params, repository, dontPersistCounters);
    }

    public Persister createGroupPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters) {
        EvaluateGroupPersister persister = new EvaluateGroupPersister(this.stats, params, repository);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }

    public Persister createOneToOnePersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters) {
        EvaluateSinglePersister persister = new EvaluateSinglePersister(this.stats, params, repository);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }
}

